/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef __BrokerInterface__
#define __BrokerInterface__

#include <qstring.h>
#include <qstringlist.h>
#include <uibinder.h>

/*
This class is part of the client core implementation.
It defines the client object broker, which is an interface to an arbitrary
collection of server ORBs.
The client-server communication is defined in CommBinder (see commbinder.h)
which acts as a transport agent for the BrokerInterface and KernelScriptEngine.
This class is unique in a Magellan client.
*/

class BrokerInterface : public UI_Binder
{
	public:
		BrokerInterface();
		~BrokerInterface();
		static BrokerInterface *thisInstance();
		
		// URL-centered methods
    bool isFolder(QString url);          // true if the url is an existent folder
    bool exists(QString url);            // true if the url is an existent folder or object
    QString parent(QString url);         // returns the logical parent of a folder or object
    QString folder(QString url);         // returns the folder parent of a folder or object
    QStringList children(QString url);   // returns the list of child objects
    QStringList subfolders(QString url); // returns the list of child folders
		QStringList related(QString url);		// returns the list of related objects
    int type(QString url);               // returns the object major type, based on its url
    int subtype(QString url);            // returns the object fine type
		
		// set methods
		bool setRelated(QString url, QStringList rList); // warning: this works on server URLs
		bool setParent(QString url, QString parentUrl);

		// object-centered methods
    bool getObjectData(QString url, QByteArray &data);
    /** Get data for many objects.*/
    bool getObjectData(QStringList &urls, QByteArray &data);
    /** Get data for many objects.*/
    bool getServerObjectsData(QStringList &urls, QByteArray &data);
    /** Get all folder's children data.*/
    bool getChildrenData(QString url, QByteArray &data);
		QByteArray getSimpleData(QString url);
    bool setObjectData(QString url, const QByteArray &data);
    /** Create a new object on the server.*/
    QString createObject(QString parent_url);
    /** Create a new folder on the server.*/
    QString createFolder(QStringList& paramList);
    QString copy(QString url, QString parent_url);
    QString move(QString url, QString parent_url);
    bool send(QString url);
    /** Remove the object.*/
    bool remove(QString url);
    /** Remove the folder.*/
    bool removeFolder(QStringList& paramList);

		// error handling
		QString lastError();
		QString regetLastError();
	private:
		QString err;
};

#endif



