/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <any.h>

Any::Any()
{
	data.truncate(0);
}

Any::Any(const QByteArray &value)
{
	data.truncate(0);
	QDataStream d(data, IO_WriteOnly);
	d<<(unsigned int)ByteArray<<value;
}

Any::Any(const QDateTime &value)
{
	data.truncate(0);
	QDataStream d(data, IO_WriteOnly);
	d<<(unsigned int)DateTime<<value;
}

Any::Any(const DateClass &value)
{
	data.truncate(0);
	QDataStream d(data, IO_WriteOnly);
	d<<(unsigned int)ExtDateTime<<value;
}

Any::Any(const QFont &value)
{
	data.truncate(0);
	QDataStream d(data, IO_WriteOnly);
	d<<(unsigned int)Font<<value;
}

Any::Any(const QPoint &value)
{
	data.truncate(0);
	QDataStream d(data, IO_WriteOnly);
	d<<(unsigned int)Point<<value;
}

Any::Any(const QSize &value)
{
	data.truncate(0);
	QDataStream d(data, IO_WriteOnly);
	d<<(unsigned int)Size<<value;
}
		
Any::Any(const QStringList &value)
{
	data.truncate(0);
	QDataStream d(data, IO_WriteOnly);
	d<<(unsigned int)StringList<<value;
}

Any::Any(const QString &value)
{
	data.truncate(0);
	QDataStream d(data, IO_WriteOnly);
	d<<(unsigned int)String<<value;
}

Any::Any(int value)
{
	data.truncate(0);
	QDataStream d(data, IO_WriteOnly);
	d<<(unsigned int)Int<<value;
}

Any::Any(double value)
{
	data.truncate(0);
	QDataStream d(data, IO_WriteOnly);
	d<<(unsigned int)Double<<value;
}

Any::operator QByteArray()
{
	unsigned int t;
	QByteArray res;
	res.truncate(0);
	if(data.size()>3)
	{
		QDataStream d(data, IO_ReadOnly);
		d>>t;
		if(t==ByteArray) d>>res;
	}
	return res;
}

QByteArray Any::toByteArray()
{
	unsigned int t;
	QByteArray res;
	res.truncate(0);
	if(data.size()>3)
	{
		QDataStream d(data, IO_ReadOnly);
		d>>t;
		if(t==ByteArray) d>>res;
	}
	return res;
}

QDateTime Any::toDateTime()
{
	unsigned int t;
	QDateTime res;
	if(data.size()>3)
	{
		QDataStream d(data, IO_ReadOnly);
		d>>t;
		if(t==DateTime) d>>res;
	}
	return res;
}

Any::operator QDateTime()
{
  return toDateTime();
}

DateClass Any::toDateClass()
{
	unsigned int t;
	DateClass res;
	if(data.size()>3)
	{
		QDataStream d(data, IO_ReadOnly);
		d>>t;
		if(t==ExtDateTime) d>>res;
	}
	return res;
}

Any::operator DateClass()
{
	return toDateClass();
}
		
QFont Any::toFont()
{
	unsigned int t;
	QFont res;
	if(data.size()>3)
	{
		QDataStream d(data, IO_ReadOnly);
		d>>t;
		if(t==Font) d>>res;
	}
	return res;
}

Any::operator QFont()
{
  return toFont();
}
		
QPoint Any::toPoint()
{
	unsigned int t;
	QPoint res;
	if(data.size()>3)
	{
		QDataStream d(data, IO_ReadOnly);
		d>>t;
		if(t==Point) d>>res;
	}
	return res;
}

Any::operator QPoint()
{
  return toPoint();
}

QSize Any::toSize()
{
	unsigned int t;
	QSize res(0, 0);
	if(data.size()>3)
	{
		QDataStream d(data, IO_ReadOnly);
		d>>t;
		if(t==Size) d>>res;
	}
	return res;
}
		
Any::operator QSize()
{
  return toSize();
}

QString Any::toString()
{
	unsigned int t;
	QString res=QString::null;
	if(data.size()>3)
	{
		QDataStream d(data, IO_ReadOnly);
		d>>t;
		if(t==String) d>>res;
	}
	return res;
}

Any::operator QString()
{
	unsigned int t;
	QString res=QString::null;
	if(data.size()>3)
	{
		QDataStream d(data, IO_ReadOnly);
		d>>t;
		if(t==String) d>>res;
	}
	return res;
}

QStringList Any::toStringList()
{
	unsigned int t;
	QStringList res;
	if(data.size()>3)
	{
		QDataStream d(data, IO_ReadOnly);
		d>>t;
		if(t==StringList) d>>res;
	}
	return res;
}

Any::operator QStringList()
{
	unsigned int t;
	QStringList res;
	if(data.size()>3)
	{
		QDataStream d(data, IO_ReadOnly);
		d>>t;
		if(t==StringList) d>>res;
	}
	return res;
}

int Any::toInt()
{
	unsigned int t;
	int res=0;
	if(data.size()>3)
	{
		QDataStream d(data, IO_ReadOnly);
		d>>t;
		if(t==Int) d>>res;
	}
	return res;
}

Any::operator int()
{
	unsigned int t;
	int res=0;
	if(data.size()>3)
	{
		QDataStream d(data, IO_ReadOnly);
		d>>t;
		if(t==Int) d>>res;
	}
	return res;
}

double Any::toDouble()
{
	unsigned int t;
	double res=0;
	if(data.size()>3)
	{
		QDataStream d(data, IO_ReadOnly);
		d>>t;
		if(t==Double) d>>res;
	}
	return res;
}

Any::operator double()
{
	unsigned int t;
	double res=0;
	if(data.size()>3)
	{
		QDataStream d(data, IO_ReadOnly);
		d>>t;
		if(t==Double) d>>res;
	}
	return res;
}

const Any& Any::operator=(const Any &a)
{
	data=a.data.copy();
	return *this;
}

bool Any::operator==(Any &a) const
{
	return data==a.rawData();
}

bool Any::operator!=(Any &a) const
{
	return data!=a.rawData();
}

Any::Type Any::type()
{
	if(data.size()<4) return Invalid;
	QDataStream d(data, IO_ReadOnly);
	unsigned int t;
	d>>t;
	return (Type)t;
}

QString Any::typeName()
{
	Type t=type();
	switch(t)
	{
		case ByteArray:
			return "ByteArray";
		case StringList:
			return "StringList";
		case String:
			return "String";
		case Int:
			return "Int";
		case Font:
			return "Font";
		case Point:
			return "Point";
		case Size:
			return "Size";
		case DateTime:
			return "DateTime";
		case ExtDateTime:
			return "ExtDateTime";
		case Double:
			return "Double";
		default:
			return "Invalid";
	}
}

bool Any::canCast(Type t)
{
	return t==type();
}

bool Any::canCast(const QString &t)
{
	return t==typeName();
}

bool Any::isValid()
{
	return type()!=Invalid;
}

bool Any::load(const QByteArray &val)
{
	if(val.size()<4) return false;
	QDataStream d(val, IO_ReadOnly);
	unsigned int t;
	d>>t;
	if(isValidType((Type)t))
	{
		data=val.copy();
		return true;
	}
	return false;
}

bool Any::isValidType(Type t)
{
	if(t==ByteArray||t==StringList||t==String||t==Int||t==Font||t==Point||t==Size||t==DateTime||t==ExtDateTime||t==Double) return true;
	return false;
}

bool Any::isValidTypeName(const QString &t)
{
	if(t=="ByteArray"||t=="StringList"||t=="String"||t=="Int"||t=="Font"||t=="Point"||t=="Size"||t=="DateTime"||t=="ExtDateTime"||t=="Double") return true;
	return false;
}

const QByteArray& Any::rawData()
{
	return (QByteArray &)data;
}

void Any::clear()
{
	data.truncate(0);
}

QDataStream& operator>>(QDataStream &s, Any &t)
{
	QByteArray d;
	s>>d;
	t.load(d);
	return s;
}

QDataStream& operator<<(QDataStream &s, const Any &t)
{
	s<<t.data;
	return s;
}
