/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef __CommFrame__
#define __CommFrame__

#include <qcstring.h>
#include <qstring.h>
#include <stdio.h>

class CommFrame
{
	public:
		// creates an empty frame
		CommFrame();

		// creates a parsed frame from the input data (check if frame is valid before usage!)
		CommFrame(QByteArray data);
		
		// resets the new data in the frame; returns true if the data gives a valid frame, otherwise false
		bool setData(QByteArray data);
		
		// converts the frame into a byte array for streaming; the byte array is null for invalid frames
		operator QByteArray();
		
		// returns true if the frame is valid; this flag is computed after the use of constructor or setData()
		bool isValid();
		
		// resets everything in the frame to 0 or false
		void reset();
		

		// frame components
		
		unsigned int frameLength;
		
		// only the least significant 4 bits are used for each revision number
		unsigned char majorRevNo, minorRevNo;
		
		bool requestFrame, replyFrame;
		bool serverFrame, clientFrame;
		bool requestsReply, deniesReply;
		bool hasStatus, hasData;
		
		unsigned int transactionTag;
		unsigned int sequenceTag;
		
		// see commands.h for descriptions
		unsigned int commandCode;
		unsigned int completionStatus; // this makes sense only in a reply
		
		// actual frame data
		unsigned int statusCode;
		QString statusString;
		QByteArray extraData;
	private:
		bool validity;		
};

#endif










