/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <stdio.h>
#include <actionwidget.h>
#include <videotoolbox.h>
#include <kapp.h>

#include <groupdialogbase.h>

#define IDSTRING "ActionWidget: "

extern VideoToolBox vtb;
#define DEBUG_AW
ActionWidget::ActionWidget(QWidget *parent, QString name,
		QFont *qfont, QFontMetrics *fontMetrics) : QFrame(parent, name)
{
	x=0; y=0;
	height=defaultActionWidgetHeight;
	width=defaultActionWidgetLength;
	if(!qfont) qf=new QFont("Helvetica",10,QFont::Normal);
	else qf=qfont;
	if(!fontMetrics) fm= new QFontMetrics(*qf);
	else fm=fontMetrics;
	DX=10; DY=10;
	vtb.setUpFonts(*qf);
}

void ActionWidget::setUpDialog()
{
#ifdef DEBUG_AW
	printf(IDSTRING"SetUpDialog()\n");
#endif
	setupSelector();
	frames=new QWidgetStack(this);
	frames->setGeometry(x,y,width,height);
	setupMessageBox();
	setupRunProgram();
	setupPlaySound();
	setupSendMail();
	frames->addWidget(messageBox,1);
	frames->addWidget(runProgram,2);
	frames->addWidget(playSound,3);
	frames->addWidget(sendMail,4);
	frames->raiseWidget(messageBox);
#ifdef DEBUG_AW
	printf(IDSTRING"SetUpDialog() done\n");
#endif
}
void ActionWidget::setGeometry(int xx, int yy, int w, int h, int ddx, int ddy)
{
	x=xx;
	y=yy;
	width=w;
	height=h;
	if(ddx) DX=ddx;
	if(ddy) DY=ddy;
}

void ActionWidget::setupMessageBox()
{
	QString name;
	int dx, dy, endx, endy;
	messageBox = new QFrame(frames,"MessageBox");
	messageBox->setFrameStyle(QFrame::Sunken | QFrame::Panel);
	int alignSize=vtb.stringLength("Message:");
	dx=DX;
	dy=DY;
	endy=height-(vtb.fontHeight()+vtb.offsetY());
	endx=width-DX;
	titleLabel=vtb.setUpLabelSize(messageBox, "Title:", alignSize, &dx, &dy);
	title=vtb.setUpLineEdit(messageBox, endx-dx, vtb.fontHeight(), &dx, &dy);
	dy+=vtb.fontHeight()+vtb.offsetY();
	dx=DX;
	messageLabel=vtb.setUpLabelSize(messageBox, "Message:", alignSize, &dx, &dy);
	message=vtb.setUpMultiLineEdit(messageBox,endx-dx,endy-dy, &dx, &dy);
	dy=endy;
	dx=DX;
	beepText=vtb.setUpLabel(messageBox,"Play sound when the dialog pops up:", &dx, &dy);
	beep=vtb.setUpToggleButton(messageBox,
		QFont("Misc",10,QFont::Bold),
		"clear.xpm", "clear.xpm", "checked.xpm",
		QFrame::Sunken | QFrame::Panel,
		QFrame::Sunken | QFrame::Panel,
		QFrame::Sunken | QFrame::Panel,
		QColor(255,255,255), QColor(255,255,255),
		QString::null,
		dx, dy+vtb.fontHeight()/2-3, 10, 10 , false);
}

void ActionWidget::setupRunProgram()
{
	runProgram= new QFrame(frames,"RunProgram");
	runProgram->setFrameStyle(QFrame::Sunken | QFrame::Panel);
	QString name;
	int dx=DX, dy=DY, endx, endy;
	int alignSize=vtb.stringLength("Command line:");
	endy=height-(vtb.fontHeight()+vtb.offsetY());
	endx=width;
	commandLabel=vtb.setUpLabelSize(runProgram, "Command line:", alignSize, &dx, &dy);
	command=vtb.setUpLineEdit(runProgram, 
		endx-dx-25-DX-vtb.offsetDef(), vtb.fontHeight(), &dx, &dy);
	browseCommand=vtb.setUpEButton(runProgram,
		QFont("Misc",10,QFont::Bold),
		"open.xpm", "open.xpm", "open.xpm",
		QFrame::Raised | QFrame::Panel,
		QFrame::Raised | QFrame::Panel,
		QFrame::Sunken | QFrame::Panel,
		QString::null,
		dx+vtb.offsetDef(), dy, 25, vtb.fontHeight());
	dy+=vtb.fontHeight()+vtb.offsetY();
	dx=DX;
	parametersLabel=vtb.setUpLabelSize(runProgram,"Parameters:", alignSize, &dx, &dy);
	parameters=vtb.setUpMultiLineEdit(runProgram, 
			endx-dx-25-DX-vtb.offsetDef(), endy-dy, &dx, &dy);
	browseParameters=vtb.setUpEButton(runProgram,
		QFont("Misc",10,QFont::Bold),
		"open.xpm", "open.xpm", "open.xpm",
		QFrame::Raised | QFrame::Panel,
		QFrame::Raised | QFrame::Panel,
		QFrame::Sunken | QFrame::Panel,
		QString::null,
		dx+vtb.offsetDef(), dy, 25, vtb.fontHeight());
	dy=endy;
	dx=DX;
	wrapLabel=vtb.setUpLabel(runProgram, "Wrap parameters on single line:", &dx, &dy);
	wrap=vtb.setUpToggleButton(runProgram,
		QFont("Misc",10,QFont::Bold),
		"clear.xpm", "clear.xpm", "checked.xpm",
		QFrame::Sunken | QFrame::Panel,
		QFrame::Sunken | QFrame::Panel,
		QFrame::Sunken | QFrame::Panel,
		QColor(255,255,255), QColor(255,255,255),
		QString::null,
		dx, dy+vtb.fontHeight()/2-3, 10, 10 , false);
}
void ActionWidget::setupPlaySound()
{
	playSound= new QFrame(frames,"PlaySound");
	playSound->setFrameStyle(QFrame::Sunken | QFrame::Panel);
	QString name;
	int dx=DX, dy=DY, endx, endy;
	int alignSize=vtb.stringLength("Player:");
	endy=height-(vtb.fontHeight()+vtb.offsetY()*3);
	endx=width;
	playerLabel=vtb.setUpLabelSize(playSound,"Player:", alignSize, &dx, &dy);
	playersList=vtb.setUpList(playSound, QFont("Fixed",12,QFont::Normal),
		endx-dx-70-DX-vtb.offsetDef(), endy, &dx, &dy);
	setDefaultPlayer=vtb.setUpEButton(playSound,
		QFont("Misc",10,QFont::Bold),
		"", "", "",
		QFrame::Raised | QFrame::Panel,
		QFrame::Raised | QFrame::Panel,
		QFrame::Sunken | QFrame::Panel,
		"Default",
		dx+vtb.offsetDef(), dy, 70, vtb.fontHeight());
	dy+=vtb.fontHeight()+vtb.offsetY();
	addPlayer=vtb.setUpEButton(playSound,
		QFont("Misc",10,QFont::Bold),
		"", "", "",
		QFrame::Raised | QFrame::Panel,
		QFrame::Raised | QFrame::Panel,
		QFrame::Sunken | QFrame::Panel,
		"Add",
		dx+vtb.offsetDef(), dy, 70, vtb.fontHeight());
	dy+=vtb.fontHeight()+vtb.offsetY();
	removePlayer=vtb.setUpEButton(playSound,
		QFont("Misc",10,QFont::Bold),
		"", "", "",
		QFrame::Raised | QFrame::Panel,
		QFrame::Raised | QFrame::Panel,
		QFrame::Sunken | QFrame::Panel,
		"Remove",
		dx+vtb.offsetDef(), dy, 70, vtb.fontHeight());
	dy=endy+vtb.offsetY()+vtb.offsetY();
	dx=DX;
	soundLabel=vtb.setUpLabelSize(playSound,"Sound:", alignSize, &dx, &dy);
	sound=vtb.setUpLineEdit(playSound, endx-dx-25-DX-vtb.offsetDef(), vtb.fontHeight(), &dx, &dy);
	browseSound=vtb.setUpEButton(playSound,
		QFont("Misc",10,QFont::Bold),
		"open.xpm", "open.xpm", "open.xpm",
		QFrame::Raised | QFrame::Panel,
		QFrame::Raised | QFrame::Panel,
		QFrame::Sunken | QFrame::Panel,
		QString::null,
		dx+vtb.offsetDef(), dy, 25, vtb.fontHeight());
	
}
void ActionWidget::setupSendMail()
{
	sendMail= new QFrame(frames,"SendMail");
	sendMail->setFrameStyle(QFrame::Sunken | QFrame::Panel);
	QString name;
	int dx=DX, dy=DY, endx, endy;
	int alignSize=vtb.stringLength("Create new e-mail");
	endy=height-(vtb.fontHeight()+vtb.offsetY()*3);
	endx=width;
	mailWindowButton=vtb.setUpEButton(sendMail,
		QFont("Misc",10,QFont::Bold),
		"new-mail-normal.xpm", "new-mail-normal.xpm", "new-mail-focus.xpm",
		QFrame::Raised | QFrame::Panel,
		QFrame::Raised | QFrame::Panel,
		QFrame::Sunken | QFrame::Panel,
		"Create new e-mail",
		dx, dy, alignSize+30, vtb.fontHeight());
	dx=DX;
	dy+=vtb.fontHeight()+vtb.offsetY();
	information=vtb.setUpLabel(sendMail, "Click the above button to create "
		"the e-mail message.", &dx, &dy);
}

void ActionWidget::setupSelector()
{
	QString name;
	int dx=DX, dy=DY;
	selectorLabel=vtb.setUpLabel(this,"Action class:", &dx, &dy);
	static bool flag=false;
	selector=vtb.setUpCombo(this, flag, vtb.stringLength("MMMMMMMMMMMMM"), &dx, &dy);
	vtb.setUpBoxContent(selector,"Send e-mail");
	vtb.setUpBoxContent(selector,"Play sound");
	vtb.setUpBoxContent(selector,"Run program");
	vtb.setUpBoxContent(selector,"Message box");
	if(!flag)
	{
		y=y+(vtb.fontHeight()+vtb.offsetY());
		height=height-(vtb.fontHeight()+vtb.offsetY());
		flag=true;
	}
	connect(selector, SIGNAL(activated(int)), this, SLOT(raiseFrame(int)));
}

void ActionWidget::raiseFrame(int index)
{
	switch(index)
	{
		case 0:
			frames->raiseWidget(messageBox);
			return;
		case 1:
			frames->raiseWidget(runProgram);
			return;
		case 2:
			frames->raiseWidget(playSound);
			return;
		case 3:
			frames->raiseWidget(sendMail);
			return;
	}
}

int main(int argc, char **argv)
{
  KApplication a(argc, argv,"VcardTest",true);
  ActionWidget av;
	av.setGeometry(10, 10, 500, 200);
	av.setUpDialog();
  a.setMainWidget(&av);
  av.show();
  return a.exec();
}

