/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <stdio.h>
#include <groupdialog.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qlistview.h>
#include <qcombobox.h>
#include <qheader.h>
#include <qmessagebox.h>
#include <miscfunctions.h>
#include <addressbookdialog.h>
#include <ataddressbook.h>
#include <addressclass.h>

#include <kicondialog.h>
#include <kiconloader.h>
#include <kconfig.h>

extern KConfig *GlobalConfig;

GroupDialog::GroupDialog(bool newObject, QWidget *parent, const char* name) :
	GroupDialogBase(parent, name, false, WDestructiveClose)//, true, 0)
{
	okButton->setEnabled(false);
	canDeleteObject=newObject;
	if(membersView)
		membersView->header()->hide();
	// set the icon for the button
}

GroupDialog::~GroupDialog()
{
	if(object->groupName().isEmpty())
	{
		if(!BrokerInterface::thisInstance()->remove(object->path()))
		{
			QMessageBox::information(0, "Delete failed",
				QString("Could not delete object.\nReason: ")+
				BrokerInterface::thisInstance()->lastError(), 1);
		}
	}
	emit(dialogClosed(object->path()));
}

void GroupDialog::setObject(GroupObject *obj)
{
	object=obj;
#ifdef DEBUG_GROUPDIALOG
	printf(" Group dialog: %s\n", (const char *)object->path());
#endif
	nameEdit->setText(obj->groupName());
	// setting up the class
	classBox->setDuplicatesEnabled(false);
	classBox->setAutoCompletion(true);
	classBox->setInsertionPolicy(QComboBox::NoInsertion);
	classBox->setEditText(join(obj->classes(),", "));
	// and now the members...
	for(int i=0;i<(obj->members()).count();i++)
		addItem((obj->members())[i]);
	// and now the icon
	KIconLoader kil;
	if(obj->icon().isEmpty())
	{
		GlobalConfig->setGroup("Group Icons");
		iconButton->setPixmap(QPixmap(GlobalConfig->readEntry("Default pixmap")));
		printf(" Group icon: [%s] (1)\n", (const char *)GlobalConfig->readEntry("Default pixmap"));
	}
	else
	{
		iconButton->setPixmap(kil.loadIcon(obj->icon(), 0));
		printf(" Group icon: [%s] (2)\n", (const char *)obj->icon());
	}
}

void GroupDialog::addItem(QString item)
{
	QCString _tmp_=(const char *)item;
	AddressClass *ac=new AddressClass(_tmp_);
	bool exists=false;
	QListViewItem *it=membersView->firstChild();
	while(!exists && it)
	{
		if((it->text(0).find((const char *)ac->translated_name,0,false)!=-1) &&
			(it->text(1).find((const char *)ac->email,0,false)!=-1))
				exists=true;
		it=it->nextSibling();
	}
	if(!exists)
	{
		QListViewItem *itemNew=new QListViewItem(membersView);
		itemNew->setText(0,(const char *)ac->translated_name);
		itemNew->setText(1,(const char *)ac->email);
		membersView->insertItem(itemNew);
	}
}


GroupObject *GroupDialog::getObject()
{
#ifdef DEBUG_GROUPDIALOG
	printf(" This will GET the object!\n");
#endif
	return object;
}

void GroupDialog::addAddress()
{
	QStringList members;
	QListViewItem *item=membersView->firstChild();
	while(item)
	{
		members.append(QString("\"")+item->text(0)+QString("\" <")+item->text(1)+">");
		item=item->nextSibling();
	}
	AddressBookDialog::addressBook(members, "Add/remove members:", this);
	for(int i=0;i<members.count();i++)
		addItem(members[i]);
}

void GroupDialog::removeAddress()
{
	QListViewItem *item=membersView->firstChild();
	while(item)
	{
		if(item->isSelected())
		{
			membersView->takeItem(item);
			item=membersView->firstChild();
		}
		else
			item=item->nextSibling();
	}
}

void GroupDialog::selectIcon()
{
	KIconDialog *kid= new KIconDialog(this);
	QString name=kid->selectIcon();
	KIconLoader kil;
	QString p=kil.iconPath(name, 0);
	if(!p.isEmpty())
	{
		iconButton->setPixmap(QPixmap(p));
	}
	object->setIcon(name);
}

void GroupDialog::nameChanged(const QString &title)
{
	setCaption(QString("Group: ")+((title.isEmpty())?QString("Undefined"):title));
	if(title.isEmpty())
	{
		okButton->setEnabled(false);
	}
	else
	{
		okButton->setEnabled(true);
	}
}

void GroupDialog::okClicked()
{
	object->setGroupName(nameEdit->text());
	object->setClasses(split(classBox->currentText(),','));
	QStringList members;
	members.clear();
	QListViewItem *item=membersView->firstChild();
	while(item)
	{
		members.append(QString("\"")+item->text(0)+QString("\" <")+item->text(1)+">");
		item=item->nextSibling();
	}
	object->setMembers(members);
	object->save();
	object->updateViews();
	AddressBook::thisInstance()->addGroup(object);
}
void GroupDialog::cancelClicked()
{
	if(canDeleteObject)
	{
		object->setGroupName(QString::null);
	}
}
