/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <phonewidgetbase.h>
#include <cardclasses.h>
#include <phonewidget.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qheader.h>
#include <qpushbutton.h>
#include <qvaluelist.h>
#include <stdio.h>
#include <prefixdialog.h>

#define IDSTRING "PhoneWidget: "

//#define DEBUG_PHONE

PhoneWidget::PhoneWidget(QPushButton *button, CardListPhones *ps, QWidget *parent=0, const char *name=0) : 	PhoneWidgetBase(parent, name, WType_Modal | WStyle_NoBorder | WX11BypassWM | WDestructiveClose)
{
	_button=button;
	setItems(ps);
	numbersList->setAllColumnsShowFocus(true);
	numbersList->header()->hide();
}

CardListPhones *PhoneWidget::items()
{
	return _items;
}

void PhoneWidget::setItems(CardListPhones *_it)
{
	_items=_it;
#ifdef DEBUG_PHONE
	printf(IDSTRING"ITEMS: %p\n", _it);
#endif
	if(!_it)
		return;
	numbersList->clear();
	QValueList<CardPhone *> p = items()->phones();
#ifdef DEBUG_PHONE
	printf(IDSTRING"count %d\n",p.count());
#endif
	for(int i=0;i<p.count();i++)
	{
		if(p[i])
		{
#ifdef DEBUG_PHONE
			printf(IDSTRING"Adding %s\n",(const char *)p[i]->number());
#endif
			QListViewItem *it = new QListViewItem(numbersList);
			it->setPixmap(0, *getPixmap(p[i]->type()));
			it->setText(1,p[i]->number());
			numbersList->insertItem(it);
			if(!i)
			{
				phoneEdit->setText(p[i]->number());
				setComboItem(p[i]->type());
			}
		}
	}
	if(p.count()==0)
	{
		replaceButton->setEnabled(false);
		removeButton->setEnabled(false);
		if(_button)
			_button->setText("No phones");
	}
	else
	{
		replaceButton->setEnabled(true);
		removeButton->setEnabled(true);
		if(_button)
			_button->setText(phoneEdit->text());
	}
}

void PhoneWidget::addPressed()
{
	if(!items())
	{
		printf(IDSTRING"Trace please: no (null) data structure for phones.\n");
		return;
	}
	if(items()->phone(phoneEdit->text()))
		return;
	// new phone
	QString phoneNo=phoneEdit->text();
	if(phoneNo.stripWhiteSpace().find("+")!=0)
	{
	 	PrefixDialog *pd;
  	pd=new PrefixDialog();
	  pd->setNumber(&phoneNo);
		pd->setType((*phoneType->pixmap(phoneType->currentItem())));
	  pd->show();
	}
	phoneEdit->setText(phoneNo);
	CardPhone *p = new CardPhone;
	p->setType(phoneType->currentText());
	p->setNumber(phoneNo);
	items()->addPhone(p);
	replaceButton->setEnabled(true);
	removeButton->setEnabled(true);
	QListViewItem *it=new QListViewItem(numbersList);
	it->setPixmap(0, *getPixmap(phoneType->currentText()));
	it->setText(1,phoneEdit->text());
	if(items()->count()==1 && _button)
		_button->setText(phoneEdit->text());
	}

void PhoneWidget::finishPressed()
{
	if(!items())
	{
		printf(IDSTRING"Trace please: no (null) data structure for phones.\n");
		return;
	}
	close();
}

void PhoneWidget::removePressed()
{
	if(!items())
	{
		printf(IDSTRING"Trace please: no (null) data structure for phones.\n");
		return;
	}
	QListViewItem *it=numbersList->currentItem();
	if(it==0)
		return;
	items()->removePhone(it->text(1));
	setItems(items());
}

void PhoneWidget::replacePressed()
{
	if(!items())
	{
		printf(IDSTRING"Trace please: no (null) data structure for phones.\n");
		return;
	}
	QListViewItem *it=numbersList->currentItem();
	if(it==0)
		return;
	it->setText(1,phoneEdit->text());
	it->setPixmap(0,*getPixmap(phoneType->currentText()));
}

void PhoneWidget::selectionChanged(QListViewItem *i)
{
	if(!items())
	{
		printf(IDSTRING"Trace please: no (null) data structure for phones.\n");
		return;
	}
	if(!i)
		return;
	phoneEdit->setText(i->text(1));
	setComboItem(items()->phone(i->text(1))->type());
}

void PhoneWidget::setComboItem(QString types)
{
	int index=3;
	if(types.find("fixed",0,false)!=-1)
		index=0;
	else if (types.find("cell",0,false)!=-1)
		index=1;
	else if (types.find("fax",0,false)!=-1)
		index=2;
	phoneType->setCurrentItem(index);
}

QPixmap *PhoneWidget::getPixmap(QString types)
{
	int index=3;
	if(types.find("fixed",0,false)!=-1)
		index=0;
	else if (types.find("cell",0,false)!=-1)
		index=1;
	else if (types.find("fax",0,false)!=-1)
		index=2;
	return (QPixmap *) phoneType->pixmap(index);
}

