/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */
 
#include <stdio.h>
#include <ecollection.h>
#include <ebutton.h>

#include <kiconloader.h>

ECollection::ECollection(QWidget *parent, const char *name):QWidget(parent, name)
{
	//QPalette p=palette();
	//p.setColor(QColorGroup::Background,black);
	//setPalette(p);
	
	persistence=false;
	oldIndex=0;
  sview=new QScrollView(this);
  sview->setFrameStyle(QFrame::NoFrame);
	sview->enableClipper(true);
	childList.clear();
	spacing=20;
	sview->setVScrollBarMode(QScrollView::AlwaysOff);
	sview->setHScrollBarMode(QScrollView::AlwaysOff);
	sview->setResizePolicy(QScrollView::Manual);
  
  button_up=new EButton(this);
  button_down=new EButton(this);
	
  button_up->setNormalPixmap(BarIcon("arrow-up-white.xpm"));
  button_up->setFocusPixmap(BarIcon("arrow-up-black.xpm"));
  button_up->setClickedPixmap(BarIcon("arrow-up-black.xpm"));
    
  button_down->setNormalPixmap(BarIcon("arrow-down-white.xpm"));
  button_down->setFocusPixmap(BarIcon("arrow-down-black.xpm"));
  button_down->setClickedPixmap(BarIcon("arrow-down-black.xpm"));

  button_up->setNormalFrameStyle(QFrame::Box|QFrame::Plain);
  button_up->setFocusFrameStyle(QFrame::WinPanel|QFrame::Raised);
  button_up->setClickedFrameStyle(QFrame::WinPanel|QFrame::Sunken);
  //button_up->setNormalBgColor(QColor("black"));
  button_up->setNormalFrameWidth(1);
  
  button_down->setNormalFrameStyle(QFrame::Box|QFrame::Plain);
  button_down->setFocusFrameStyle(QFrame::WinPanel|QFrame::Raised);
  button_down->setClickedFrameStyle(QFrame::WinPanel|QFrame::Sunken);
  //button_down->setNormalBgColor(QColor("black"));
  button_down->setNormalFrameWidth(1);
  
  button_up->setGeometry(0, 0, width(), 15);
  sview->setGeometry(1, 10, width()-2, height()-30);
  button_down->setGeometry(0, height()-16, width(), 15); 
  
  connect(button_up, SIGNAL(clicked()), this, SLOT(scroll_up()));
  connect(button_down, SIGNAL(clicked()), this, SLOT(scroll_down()));
  
  button_up->repaint();
  button_down->repaint();
  
  button_up->show();
  sview->show();
  button_down->show();
}
	
ECollection::~ECollection()
{
  delete(sview);
  delete(button_up);
  delete(button_down);
}

void ECollection::setSpacing(int s)
{
	spacing=s;
}

void ECollection::addButton(const QPixmap &p, QObject *receiver, const char *slot)
{
	EButton *b=new EButton(p, sview->viewport());
  addButton(b, receiver, slot);
}

void ECollection::addButton(EButton *b, QObject *receiver, const char *slot)
{
  if(b==0) return;
	b->setIndex(childList.count());
  b->setCollectionStyle();
	sview->resizeContents(width(), height()+(b->height()+spacing)+spacing);
  sview->addChild(b, (sview->width()-b->width())/2, childList.count()*(b->height()+spacing)+spacing);
	childList.append(b);

	b->show();
	/**
	 *		Setting up the persistence for the first item of the list.
	 */
	if(persistence && (b->getIndex()==0))
	{
		oldIndex=0;
		oldPixmap=b->getPixmap(EButton::Normal);
		QPixmap focusPix=b->getPixmap(EButton::Focus);
		b->setNormalPixmap(focusPix);
	}
	connect(b, SIGNAL(indexClicked(int)), this, SLOT(button_clicked(int)));
}

void ECollection::resizeEvent(QResizeEvent *e)
{
  button_up->setGeometry(0, 0, width(), 15);
  sview->setGeometry(1, 15, width()-2, height()-30);
  button_down->setGeometry(0, height()-16, width(), 15); 

	if(childList.count())
		sview->resizeContents(width(), childList.count()*(childList.at(0)->height()+spacing)+spacing);
	int i;
	for(i=0;i<childList.count();i++)
	{
		sview->moveChild(childList.at(i), (width()-childList.at(0)->width())/2, 
				i*(childList.at(0)->height()+spacing)+spacing);
		childList.at(i)->show();
	}
}

void ECollection::scroll_up()
{
  if(childList.count())
	{
    for(int i=0;i<childList.at(0)->height()+spacing;i++)
    {
      sview->scrollBy(0, -1);
    }
	}
}

void ECollection::scroll_down()
{
  if(childList.count())
	{
    for(int i=0;i<childList.at(0)->height()+spacing;i++)
    {
      sview->scrollBy(0, 1);
    }
	}
}

void ECollection::setPersistence(bool p)
{
	persistence=p;
}

void ECollection::button_clicked(int which)
{
	/**
	 *	If the persistence is false, then I have the same "all buttons look alike"
	 */
	if(!persistence)
	{
		if(oldIndex!=which)
		{
			oldIndex=which;
			emit newButtonClicked(which);
		}
		return;
	}
	/**
	 *	If the same button is clicked, nothing happens
	 */
	if(which==oldIndex)
		return;
	/**
	 *	If other button was clicked, then the procedure is as follows:
	 *		1. set the old button's Normal pixmap
	 *		2. get the new button's index in oldIndex
	 *		3. get the new button's Normal pixmap in oldPixmap
	 *		4. get the new button's Focus pixmap in focusPixmap (local variable)
	 *		5. set the new button's normal to be the same as the focus one
	 */
	childList.at(oldIndex)->setNormalPixmap(oldPixmap);
	oldIndex=which;
	oldPixmap=childList.at(oldIndex)->getPixmap(EButton::Normal);
	QPixmap focusPixmap=childList.at(oldIndex)->getPixmap(EButton::Focus);
	childList.at(oldIndex)->setNormalPixmap(focusPixmap);
	emit newButtonClicked(oldIndex);
}
