/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <epanel.h>
#include <kiconloader.h>

EPanel::EPanel(QWidget *parent, const char *name):QWidget(parent, name)
{
	child=0;
	top=new QWidget(this);
	
	closeButton=new EButton(BarIcon("close.xpm"), top);
	closeButton->setToolBarStyle(15);
	
	connect(closeButton, SIGNAL(clicked()), this, SLOT(close()));
}

void EPanel::setWidget(QWidget *w)
{
	if(w)
	{
		child=w;
		if(child->parentWidget()!=this)
			child->reparent(this, 0, QPoint(0, 0), false);
	}
}

void EPanel::resizeEvent(QResizeEvent *e)
{
	QWidget::resizeEvent(e);
	
	top->setGeometry(0, 0, width(), 15);
	closeButton->setGeometry(width()-15, 0, 15, 15);
	
	if(child)
		child->setGeometry(0, 15, width(), height()-15);
}

void EPanel::closeEvent(QCloseEvent *e)
{
	QWidget::closeEvent(e);
	emit(closed());
}
