/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */


#ifndef __Has_EPixBar__
#define __Has_EPixBar__

#include <qlabel.h>
#include <qpixmap.h>
#include <qcolor.h>
#include <qvaluelist.h>

class EPixWidget;

class EPixBar : public QLabel
{
	Q_OBJECT
	public:
		enum { FixedSize=1, DynamicSize=2, PixmapProgress=4, SmallProgress=8 };
		enum { MultipleActives=1, ExclusiveActives=2};
		EPixBar(QWidget *parent=0, const char *name=0);
		void setActiveType(int type=ExclusiveActives);
		void loadWidget(QPixmap, QPixmap, QPixmap, QPixmap);
		int activeType();
		void setActive(int, bool);
		int active();
		void setProgressColor(QColor, int pos=-1);
		void setTicksPerProgress(int, int pos=-1);
		void setTicker(int, int pos=-1);
		void tick();
		void forceTicks(int, int pos=-1);
		int getTicks(int pos=-1);
		void reset(int pos=-1);
		void setStyle(int, int pos=-1);
		void setWidthMargin(int, int pos=-1);
		void setHeightMargin(int, int pos=-1);
		int widthMargin(int pos=-1);
		int heightMargin(int pos=-1);
	public slots:
		void sizeChanged(int, int, int);
	private:
		void setupGeometry();
		QValueList<EPixWidget *> widgets;
		int _activeType;
		int x, y, dx, dy;
		int defaultMargins[2];
		
};

class EPixWidget : public QLabel
{
	Q_OBJECT
	public:
		EPixWidget(QWidget *parent=0, const char *name=0);
		
		void loadPixmap(QPixmap, QPixmap, QPixmap, QPixmap);
		void setId(int);
		int id();
		void setActive(bool);
		bool isActive();
		void setTicker(int);
		void forceTicks(int);
		void setTicksPerProgress(int);
		void setProgressColor(QColor);
		int ticker();
		void tick();
		int getTicks();
		void reset();
		void setStyle(int);
		void setWidthMargin(int);
		void setHeightMargin(int);
		int widthMargin();
		int heightMargin();
	signals:
		void sizeChanged(int, int, int);
	private:
		void initFixedSize();
		void initDynamicSize();
		void initPixmapProgress();
		void initSmallProgress();
		
		void setActiveFixedSize(bool);
		void setActiveDynamicSize(bool);
		void setActivePixmapProgress(bool);
		void setActiveSmallProgress(bool);
		
		void tickFixedSize();
		void tickDynamicSize();
		void tickPixmapProgress();
		void tickSmallProgress();
		
		QPixmap small0, small1, large0, large1;
		QPixmap activePix0, activePix1;
		int ticks, currentTick, ticksPerProgress;
		int _widthMargin, _heightMargin;
		bool active, initialised;
		QColor progressColor;
		int style;
		bool initPixmap;
		QLabel *pixLabel;
		int _id;
};

#endif
