/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <stdio.h>
#include <ebutton.h>
#include <etogglebutton.h>
#include <kapp.h>

#define IDSTRING "EToggleButton: "

//#define DEBUG_TOGGLE_BUTTON

EToggleButton::EToggleButton(QWidget *parent, const char *name, int index) :
	EButton(parent, name, index)
{
	setDefaults();
}
void EToggleButton::setStyles(int click, int focus, int normal)
{
	clickedStyle=click;
	focusStyle=focus;
	normalStyle=normal;
}

EToggleButton::EToggleButton(const QPixmap &npix, 
		QWidget *parent,
		const char *name,
		int index) : EButton(npix, parent, name, index)
{
	setDefaults();
}

EToggleButton::EToggleButton(const QString &text, 
		QWidget *parent,
		const char *name,
		int index) : EButton(text, parent, name, index)
{
	setDefaults();
}

void EToggleButton::toggleFrame()
{
	if(!toggled)
	{
		setFocusFrameStyle(focusStyle);
		setNormalFrameStyle(focusStyle);
		setClickedFrameStyle(clickedStyle);
	}
	else
	{
		setFocusFrameStyle(clickedStyle);
		setNormalFrameStyle(clickedStyle);
		setClickedFrameStyle(focusStyle);
	}
}
void EToggleButton::togglePixmap()
{
	QPixmap tmp=getPixmap(EButton::Normal);
	setNormalPixmap(getPixmap(EButton::Clicked));
	setFocusPixmap(getPixmap(EButton::Clicked));
	setClickedPixmap(tmp);
}
void EToggleButton::toggleColor()
{
	if(!toggled)
	{
		setNormalBgColor(normalColor);
		setFocusBgColor(normalColor);
		setClickedBgColor(toggledColor);
	}
	else
	{
		setNormalBgColor(toggledColor);
		setFocusBgColor(toggledColor);
		setClickedBgColor(normalColor);
	}
	repaint();
}
void EToggleButton::setDefaults()
{
	setSpacing(0); setContentMargin(0);
	toggled=false;
	normalColor=QColor("black");
	toggledColor=QColor(100,100,100);
	clickedStyle=QFrame::WinPanel|QFrame::Sunken;
	focusStyle=QFrame::WinPanel|QFrame::Raised;
	normalStyle=QFrame::NoFrame;
	toggleFrame();
	toggleColor();
	connect(this, SIGNAL(clicked()), this, SLOT(slotClicked()));
}

void EToggleButton::setToggled(bool t)
{
	toggled=t;
	toggleFrame();
	toggleColor();
	repaint();
}
void EToggleButton::setToggledColor(QColor tc)
{
	toggledColor=tc;
	toggleColor();
	repaint();
}
void EToggleButton::setNormalColor(QColor tc)
{
	normalColor=tc;
	toggleColor();
	repaint();
}
void EToggleButton::slotClicked()
{
	toggled=!toggled;
	toggleFrame();
	toggleColor();
	togglePixmap();
	repaint();
#ifdef DEBUG_TOGGLE_BUTTON
	printf(IDSTRING"Toggled = %d\n", toggled);
#endif
	emit signalToggled(toggled);
}







