#ifndef __MetaFormatControl__
#define __MetaFormatControl__

#include <qstring.h>
#include <qstringlist.h>
#include <qstrlist.h>

// MetaFormatControl structure definition

class MetaFormatControl
{
	public:
		MetaFormatControl();
		~MetaFormatControl();
		static MetaFormatControl *ref();
		void refresh();

		static MetaFormatControl *thisInstance;

		// control params
		bool enableReplyTags;
		bool enableBlockReplyTags;
		bool enableNextLineFolding;
		bool enableAnySequence;
		bool enableInlineNumberingSequence;
		bool enableNumberingSequence;
		bool enableBulletSequence;
		bool enableWroteSequence;

		// numbering
		int numberingSetThreshold;

		// inline numbering
		int inlineNumberingSetThreshold;

		// bullets
		int bulletSetThreshold;

		// param data
		class SeqTag
		{
			public:
				SeqTag();
				SeqTag(const QString &, const QString &, const QString &, const QString &);
				SeqTag(const QString &, const QString &);
				QString beginPattern, textPattern, endPattern, tag;
				bool strip;
		};

		QValueList<SeqTag> anyData;
		QValueList<SeqTag> inlineNumberingData;
		QValueList<SeqTag> numberingData;
		QValueList<SeqTag> bulletData;
		QStrList wroteData;
		QStrList replyData;
};

#endif
