/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <string.h>
#include <netgroup.h>

/** Please use only secconds for timeouts!*/

#define CONNECTION_TIMEOUT    20
#define REPLY_TIMEOUT         10
#define READ_TIMEOUT          10
#define WRITE_TIMEOUT         20

NetGroup::NetGroup()
{
  // normal speed category
	connectionTimeout=CONNECTION_TIMEOUT;
	replyTimeout=REPLY_TIMEOUT;
	readTimeout=READ_TIMEOUT;
	writeTimeout=WRITE_TIMEOUT;
}

NetGroup::NetGroup(const char *category)
{
	if(category==0 || strcmp(category, "normal")==0)
	{
		connectionTimeout=CONNECTION_TIMEOUT;
		replyTimeout=REPLY_TIMEOUT;
		readTimeout=READ_TIMEOUT;
		writeTimeout=WRITE_TIMEOUT;
	}
	else if(strcmp(category, "slow")==0)
	{
		connectionTimeout=120;
		replyTimeout=60;
		readTimeout=60;
		writeTimeout=60;
	}
	else if(strcmp(category, "very slow")==0)
	{
		connectionTimeout=240;
		replyTimeout=120;
		readTimeout=120;
		writeTimeout=120;
	}
	else
	{
		connectionTimeout=CONNECTION_TIMEOUT;
		replyTimeout=REPLY_TIMEOUT;
		readTimeout=READ_TIMEOUT;
		writeTimeout=WRITE_TIMEOUT;
	}
}

int NetGroup::getDefaultConnectionTimeout()
{
	return CONNECTION_TIMEOUT;
}

int NetGroup::getDefaultReplyTimeout()
{
	return REPLY_TIMEOUT;
}

int NetGroup::getDefaultReadTimeout()
{
	return READ_TIMEOUT;
}

int NetGroup::getDefaultWriteTimeout()
{
	return WRITE_TIMEOUT;
}

int NetGroup::getConnectionTimeout()
{
	return connectionTimeout;
}

int NetGroup::getReplyTimeout()
{
	return replyTimeout;
}

int NetGroup::getReadTimeout()
{
	return readTimeout;
}

int NetGroup::getWriteTimeout()
{
	return writeTimeout;
}

