/***************************************************************************
            pop3uidjar.cpp  -  the UID jar for pop3 accounts
                             -------------------
    begin                : Wed Mar 14 19:02:00 EET 2001
    copyright            : (C) 2001 by theKompany (www.thekompany.com>
    author               : Eugen Constantinescu
    email                : eug@thekompany.com
 ***************************************************************************/

#include <pop3uidjar.h>
#include <kconfig.h>
#include <qstring.h>

extern KConfig *GlobalConfig;

POP3_UIDJar *POP3_UIDJar::thisInstance;

POP3_UIDJar::POP3_UIDJar() : UIDJar()
{
  setupFiles();
  loadLists();
}

POP3_UIDJar::~POP3_UIDJar()
{
}

POP3_UIDJar *POP3_UIDJar::ref()
{
	return thisInstance?thisInstance:(thisInstance=new POP3_UIDJar());
}

void POP3_UIDJar::setupFiles()
{
  GlobalConfig->setGroup("Directory");
	QString mgdir=GlobalConfig->readEntry("AetheraDir");
	
  rcvFileName=mgdir.latin1();
  rcvFileName+="/internal/rcvuids";
  delFileName=mgdir.latin1();
  delFileName+="/internal/deluids";
}

void POP3_UIDJar::markForDeletion(const char *uid)
{
  UIDINFO uidData;
  uidData.info="null";
  uidData.rcvTime=0;
  // Insert the deleted UID
  if( strlen(uid) )
	  trashList.insert(UIDValuePair(string(uid), uidData));
	// Save the list - !?
	saveLists();
}

void POP3_UIDJar::rcvInsert(string uid, unsigned int rcvTime)
{
  UIDINFO uidData;
  uidData.info="null";
  uidData.rcvTime=rcvTime;
  // Insert the deleted UID
  if( uid.size() )
	  rcvList.insert(UIDValuePair(uid, uidData));
}


