/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-1999 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-1999 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/                                                         
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <blockdev.h>
#include <qfile.h>
#include <qdatastream.h>
#include <transactionserver.h>

//#define DEBUG_BLOCKDEV

BlockDevice::BlockDevice(QString filename, QString prefix):DataCollection(prefix)
{
#ifdef DEBUG_BLOCKDEV
	printf("BlockDevice: entering the constructor...\n");
#endif
  storageDevice=filename;
  type=FileStorage;
  buildEntryList();
}

BlockDevice::~BlockDevice()
{
}

void BlockDevice::buildEntryList()
{
#ifdef DEBUG_BLOCKDEV
	printf("BlockDevice: Building entry list...\n");
#endif
  QFile dfile(storageDevice);
  if(dfile.open(IO_ReadOnly))
  {
    QDataStream stream(&dfile);
    while(!stream.atEnd())
    {
			// create a new object
      int offset=dfile.at();
      ObjectReference *tobj=new ObjectReference;
			QString id;
		
			// read the object id
			
			stream>>id;
			
			// test the id
			
			if(!isValidID(id) || getEntryDict()[id])
				id=nextID(); // not valid, reassign id
			
			// read the object data
      stream>>tobj->rawData;
      tobj->length=tobj->rawData.size();
      tobj->offset=offset;
			tobj->id=id;
			tobj->isNewObject=false;

			// debug
#ifdef DEBUG_BLOCKDEV
      printf("  -block object id: %s, device: %s, offset: %d, length: %d\n",
					(const char *)id,
					(const char *)storageDevice, 
          tobj->offset, tobj->length);
#endif
			addEntry(tobj);
			// set lastID accordingly
			unsigned long idNumber=id.mid(idPrefix.length()).toULong();
			if(idNumber>lastIDNum)
				lastIDNum=idNumber;			
    }
  }
}

bool BlockDevice::removeEntry(QString id, bool sync)
{
  ObjectReference *t=ref(id);
  if(t)
  {
    objectList.remove(t);
    delete(t);
    if(sync)
      return TransactionServer::thisInstance()->save(this);
    else
      return true; // sync later
  }
  
  return false; // object does not exist
}
