/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <orb.h>
#include <magellan.h>
#include <mailclasses.h>
#include <indexclass.h>
#include <transactionserver.h>
#include <attributemarshall.h>
#include <conversions.h>
#include <messagedevice.h>
#include <accountmanager.h>
#include <pop3uidjar.h>
#include <accounts.h>
#include <imap4handler.h>

bool ObjectRequestBroker::remove(QString url)
{
	if(!exists(url))
	{
		printf("orb: removed called for a non-existent object (%s), bailing out\n", (const char *)url);
		err="Cannot delete a non-existent object";
		return false;
	}
	
	// debug
	printf("orb: trying to delete %s\n", (const char *)url);

// Eugen C. - the following is commented because I made
// a new removeFolder() method for removing folders.
//
//  remove folder
//	if(isFolder(url))
//	{
//		if(url.left(3)=="sys")
//		{
//			// debug
//			printf("orb: cannot delete a system folder\n");
//			
//			err="Cannot delete a system folder";
//			return false;
//		}
//
//		err="Unknown error: incomplete remove";		
//    return removeFolder(url);
//	}
	
	int stype=subtype(url);
	
	// MIME part
	if(stype==Magellan::Part)
	{
		int partID=url.mid(url.find('.')+1).toInt();
		QString indexID=url.left(url.find('.'));
		IndexClass *idx=indexReference(indexID);
		return MessageDevice(idx).deletePart(partID);
	}

	// mail	
	if(stype==Magellan::Message)
	{
		IndexClass *idx=indexReference(url);
		if(!idx)
		{
			printf("Warning: URLManager::indexReference() returned null when a valid pointer was expected, bailing out\n");
			err="Internal error in URLManager::indexReference()";
			return false;
		}
		
		if(idx->isLocked())
		{
			printf("Warning: message is locked, cannot delete\n");
			err="Message was locked by the mail spooler, cannot delete";
			return false;
		}

		// check to see if message should be mark for deletion in the uid jar
		MessageDevice dev(idx);
		dev.loadDescriptor();
		
		Account *acc=AccountManager::ref()->getAccount(dev.getDescriptor().account);
		
		// debug
		printf("orb_remove: device account is %s, ptr %p\n", (const char *)dev.getDescriptor().account, acc);
		
		if(acc && acc->sync)
		{
			if(!dev.getDescriptor().uid.isEmpty())
				POP3_UIDJar::ref()->markForDeletion((const char *)dev.getDescriptor().uid);
			else
				printf("Warning: could not mark message for deletion, empty uid\n");
		}
		else
		{
			printf("orb_remove: did not mark message for deletion (account not found or not synchronized)\n");
		}
				
		err="Internal error in LocalMailFolder::deleteMessage()";
		idx->getParentFolder()->deleteMessage(idx);
		
		return true;
	}
	
	QString name=object(url), pfolder=folder(url);
	DataCollection *d=folderReference(pfolder);
	if(!d)
	{
		printf("Warning: URLManager::folderReference() returned null when a valid pointer was expected, bailing out\n");
		err="Internal error in URLManager::folderReference()";
		return false;
	}
	
	d->removeEntry(name);
	if(d->type==DataCollection::FolderStorage)
		TransactionServer::thisInstance()->save(d);
	
	ServerNotifier::thisInstance()->objectDeleted(url);
	
  return true;
}

bool ObjectRequestBroker::removeFolder(QStringList paramList)
{
	QString account, mailbox, serverPath, type, viewType;
	unsigned i=0;
	
	for(QStringList::Iterator it=paramList.begin(); it!=paramList.end(); ++it)
	{
	  switch(i)
	  {
	    case 0:
	      type=(*it);
	      break;
	    case 1:
	      viewType=(*it);
	      break;
	    case 2:
	      serverPath=(*it);
	      break;
	    case 3:
	      account=(*it);
	      break;
	    case 4:
	      mailbox=(*it);
	      break;
	  }
	  i++;
	}
	
  if(serverPath.left(3)=="sys")
  {
  	// debug
  	printf("orb: cannot delete a system folder\n");
  			
  	err="Cannot delete a system folder";
  	return false;
  }

  err="Unknown error: incomplete remove";		
  // for IMAP send only the delete folder command
  if( type=="imap" )
    return IMAP4Handler::ref()->deleteFolder(account, mailbox, serverPath);
  else
    return CollectionManager::removeFolder(serverPath);
}




