#include <stdio.h>
#include <qwidget.h>
#include <qstringlist.h>
#include <qmessagebox.h>
#include <simpleconfig.h>
#include <kconfig.h>
#include <qfile.h>
#include <qfont.h>
#include <qsize.h>
#include <qpoint.h>
#include <qdir.h>
#include <qtextstream.h>
#include <qregexp.h>

#define RELEASE_VERSION "Beta 4"

extern KConfig *GlobalConfig;

bool processScript(QWidget *parent, QStringList &script)
{
	// debug
	printf("\nscript: %s\n", (const char *)script.join("\n"));
	
	SimpleConfig cfg(script);
	
	// These files are used only for IMAP
	QString serverPath;
	QString inboxFolder;
	
	// write common entries
	
	// debug
	cfg.setGroup("Choose Dir");
	printf("Writing top-level dir: %s\n", (const char *)cfg.readEntry("Directory"));
	
	// top level directory
	GlobalConfig->setGroup("Directory");
	cfg.setGroup("Choose Dir");
	GlobalConfig->writeEntry("AetheraDir", cfg.readEntry("Directory"));
	
	// the plug in directory
 	GlobalConfig->setGroup("PlugInManager");
	cfg.setGroup("PlugIn Dir");
  GlobalConfig->writeEntry("PlugInDirectory", cfg.readEntry("Directory"));
 	GlobalConfig->writeEntry("PlugIns", "jabber,korganizer");
	
	// appearance
	GlobalConfig->setGroup("Appearance");
	GlobalConfig->writeEntry("Browse", "200");
	GlobalConfig->writeEntry("Contents", "700");
	GlobalConfig->writeEntry("Geometry", "161,133,900,500");
	GlobalConfig->writeEntry("Style", "kde");
	
	// contacts
	GlobalConfig->setGroup("Contacts");
	GlobalConfig->writeEntry("View mode", "tile");
	GlobalConfig->writeEntry("View columns", "Name:fn;E-mail:email;Work address:work address;Mobile phone:mobile");
	GlobalConfig->writeEntry("View fields", "name;email;work address");
	
	// attach vcard
	GlobalConfig->setGroup("Misc Mail");
	cfg.setGroup("Identity");
	GlobalConfig->writeEntry("Attach VCard", cfg.readEntry("Attach"));
	
	// composer options
	GlobalConfig->setGroup("Composer");
	GlobalConfig->writeEntry("Bcc", "Yes");
	GlobalConfig->writeEntry("QuoteChar", ">");
	GlobalConfig->writeEntry("Wrap", "Yes");
	GlobalConfig->writeEntry("Font", QFont("courier", 12));
	
	// misc mail options
	GlobalConfig->setGroup("Misc Mail");
	GlobalConfig->writeEntry("Goto", "Unread");
	GlobalConfig->writeEntry("Permanent delete", "No");
	
	// threading
	GlobalConfig->setGroup("Threading");
	GlobalConfig->writeEntry("Enable", "Yes");
	GlobalConfig->writeEntry("Complete references", "No");
	GlobalConfig->writeEntry("Thread by", "References");
	GlobalConfig->writeEntry("Thread anyway", "Yes");
	
	// notes options
	GlobalConfig->setGroup("Notes");
	GlobalConfig->writeEntry("Default color", "yellow");
	GlobalConfig->writeEntry("Default size", QSize(200, 200));
	GlobalConfig->writeEntry("Default font", QFont("helvetica", 12));
	
	// groups pixmaps association
	GlobalConfig->setGroup("Group Icons");
	GlobalConfig->writeEntry("Default pixmap", "xpm/groups/contacts-group-large.xpm");
	
	// quote options
	GlobalConfig->setGroup("Quote Options");
	GlobalConfig->writeEntry("Compression Treshold", 3);
	GlobalConfig->writeEntry("HTML Beautify", "Yes");
	GlobalConfig->writeEntry("HTML Compression", "Yes");
	GlobalConfig->writeEntry("HTML Max Second Line Length", 55);
	GlobalConfig->writeEntry("HTML Quotation", "Yes");
	GlobalConfig->writeEntry("HTML Uniformize", "Yes");
	GlobalConfig->writeEntry("Header Mid", "bgcolor=#f3f0f0 width=100%><font face=\"Helvetica,Arial,Times\" color=#000000><b>");
	GlobalConfig->writeEntry("Header Prefix", "<table width=100% border=0 cellpadding=0><tr><td");
	GlobalConfig->writeEntry("Header Suffix", "</b></font></td></tr></table>");
	GlobalConfig->writeEntry("Indenting String", "&nbsp;&nbsp;&nbsp;&nbsp;");
	GlobalConfig->writeEntry("Normal Prefix", "<font face=\"Helvetica,Arial,Times\", size=3 color=#000000><tt>");
	GlobalConfig->writeEntry("Normal Suffix", "</tt></font>");
	GlobalConfig->writeEntry("Quote Prefix", "<font face=\"Helvetica,Arial,Times\" color=\"#a0a0a0\">");
	GlobalConfig->writeEntry("Quote Separators", "\"&nbsp;\",\" \"");
	GlobalConfig->writeEntry("Quote Strings", "\"&gt;\",\"**\",\" &gt;\"");
	GlobalConfig->writeEntry("Quote Suffix", "</font><br>");

	// read options
	GlobalConfig->setGroup("Read Options");
	GlobalConfig->writeEntry("Body Color", "000000");
	GlobalConfig->writeEntry("BodyBgColor", "FFFFFF");
	GlobalConfig->writeEntry("Default Font", "Helvetica, Gothic, Arial, Times");
	GlobalConfig->writeEntry("Default Font Color", "000000");
	GlobalConfig->writeEntry("Default Font Size", "3");
	GlobalConfig->writeEntry("Email default action", "new");
	GlobalConfig->writeEntry("Has Font", "Yes");
	GlobalConfig->writeEntry("Preffer HTML", "Yes");

	GlobalConfig->setGroup("Folder Management");
	GlobalConfig->writeEntry("Waste", 102400);
		
	// vfs
	GlobalConfig->setGroup("VFS Init");
	GlobalConfig->writeEntry("TopLevel", "/Magellan/Contacts,/Magellan/Groups,/Magellan/Mail,/Magellan/Notes");
	
	GlobalConfig->setGroup("VFS /Magellan/Contacts");
	GlobalConfig->writeEntry("Binding", "thisInstance");
	GlobalConfig->writeEntry("Server Path", "syscontacts");
	GlobalConfig->writeEntry("Type", "contacts");
	GlobalConfig->writeEntry("Flags", "c");
	GlobalConfig->writeEntry("View type", "contacts");
	GlobalConfig->writeEntry("MIME type", "text/directory");

	
	GlobalConfig->setGroup("VFS /Magellan/Mail/Deleted Messages");
	GlobalConfig->writeEntry("Binding", "thisInstance");
	GlobalConfig->writeEntry("Server Path", "sysmail_deleted");
	GlobalConfig->writeEntry("Type", "mail");
	GlobalConfig->writeEntry("Flags", "c");
	GlobalConfig->writeEntry("View type", "deleted");
	GlobalConfig->writeEntry("MIME type", "text/rfc822");
	
	GlobalConfig->setGroup("VFS /Magellan/Mail/Drafts");
	GlobalConfig->writeEntry("Binding", "thisInstance");
	GlobalConfig->writeEntry("Server Path", "sysmail_drafts");
	GlobalConfig->writeEntry("Type", "mail");
	GlobalConfig->writeEntry("Flags", "c");
	GlobalConfig->writeEntry("View type", "drafts");
	GlobalConfig->writeEntry("MIME type", "text/rfc822");
	
	GlobalConfig->setGroup("VFS /Magellan/Groups");
	GlobalConfig->writeEntry("Binding", "thisInstance");
	GlobalConfig->writeEntry("Server Path", "sysgroups");
	GlobalConfig->writeEntry("Type", "groups");
	GlobalConfig->writeEntry("Flags", "c");
	GlobalConfig->writeEntry("View type", "groups");
	GlobalConfig->writeEntry("MIME type", "application/x-groups");
	
	GlobalConfig->setGroup("VFS /Magellan/Mail/Inbox");
	GlobalConfig->writeEntry("Binding", "thisInstance");
	GlobalConfig->writeEntry("Server Path", "sysmail_inbox");
	GlobalConfig->writeEntry("Type", "mail");
	GlobalConfig->writeEntry("Flags", "c");
	GlobalConfig->writeEntry("View type", "inbox");
	GlobalConfig->writeEntry("MIME type", "text/rfc822");
	
	GlobalConfig->setGroup("VFS /Magellan/Mail");
	GlobalConfig->writeEntry("Type", "genmail");
	GlobalConfig->writeEntry("Subfolders", "/Magellan/Mail/Inbox,/Magellan/Mail/Outbox,/Magellan/Mail/Drafts,/Magellan/Mail/Saved Messages,/Magellan/Mail/Sent Mail,/Magellan/Mail/Deleted Messages");
	GlobalConfig->writeEntry("Flags", "c");
	GlobalConfig->writeEntry("View type", "genmail");
	GlobalConfig->writeEntry("MIME type", "");
	
	GlobalConfig->setGroup("VFS /Magellan/Notes");
	GlobalConfig->writeEntry("Binding", "thisInstance");
	GlobalConfig->writeEntry("Server Path", "sysnotes");
	GlobalConfig->writeEntry("Type", "notes");
	GlobalConfig->writeEntry("Flags", "c");
	GlobalConfig->writeEntry("View type", "notes");
	GlobalConfig->writeEntry("MIME type", "application/x-notes");
	
	GlobalConfig->setGroup("VFS /Magellan/Mail/Outbox");
	GlobalConfig->writeEntry("Binding", "thisInstance");
	GlobalConfig->writeEntry("Server Path", "sysmail_outbox");
	GlobalConfig->writeEntry("Type", "mail");
	GlobalConfig->writeEntry("Flags", "c");
	GlobalConfig->writeEntry("View type", "outbox");
	GlobalConfig->writeEntry("MIME type", "text/rfc822");

	GlobalConfig->setGroup("VFS /Magellan/Mail/Saved Messages");
	GlobalConfig->writeEntry("Binding", "thisInstance");
	GlobalConfig->writeEntry("Server Path", "sysmail_saved");
	GlobalConfig->writeEntry("Type", "mail");
	GlobalConfig->writeEntry("Flags", "c");
	GlobalConfig->writeEntry("View type", "saved");
	GlobalConfig->writeEntry("MIME type", "text/rfc822");

	GlobalConfig->setGroup("VFS /Magellan/Mail/Sent Mail");
	GlobalConfig->writeEntry("Binding", "thisInstance");
	GlobalConfig->writeEntry("Server Path", "sysmail_sent");
	GlobalConfig->writeEntry("Type", "mail");
	GlobalConfig->writeEntry("Flags", "c");
	GlobalConfig->writeEntry("View type", "sent");
	GlobalConfig->writeEntry("MIME type", "text/rfc822");
	
	// new html processing options
	GlobalConfig->setGroup("HTML Parser");
	GlobalConfig->writeEntry("Reply pattern","&gt; ,&gt;");
	GlobalConfig->writeEntry("Reply begin tag",
		"<table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\"><tr><td valign=\"top\">");
	GlobalConfig->writeEntry("Reply end tag","</font></td></tr></table>");
	GlobalConfig->writeEntry("Reply middle tag","</td><td><font color=\"#a0a0a0\">");
	GlobalConfig->writeEntry("Reply tabulator","&nbsp;&nbsp;&nbsp;&nbsp;");
	GlobalConfig->writeEntry("Reply duplicate tabulator","No");
	GlobalConfig->writeEntry("Wrote pattern","wrote:,wrote :");
	GlobalConfig->writeEntry("Wrote begin tag",
		"<table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\"><tr><td bgcolor=\"#e0e0e0\"><b>&nbsp;");
	GlobalConfig->writeEntry("Wrote end tag","</b></td></tr></table>");
	GlobalConfig->writeEntry("Text only","No");
	GlobalConfig->writeEntry("Max parsing size","8192");
	GlobalConfig->writeEntry("Builtin rules","Important,Arrows");
	GlobalConfig->writeEntry("Custom rules","");
	GlobalConfig->writeEntry("Active rules","Important,Arrows");

	GlobalConfig->setGroup("HTML Rule Important");
	GlobalConfig->writeEntry("Begin pattern","\\*");
	GlobalConfig->writeEntry("Body pattern",".+");
	GlobalConfig->writeEntry("End pattern","\\*");
	GlobalConfig->writeEntry("Begin HTML","<font color=\"#800000\"><b>");
	GlobalConfig->writeEntry("End HTML","</b></font>");

	GlobalConfig->setGroup("HTML Rule Arrows");
	GlobalConfig->writeEntry("Begin pattern","&gt\\;&gt\\;");
	GlobalConfig->writeEntry("Body pattern",".*");
	GlobalConfig->writeEntry("End pattern","&lt\\;&lt\\;$");
	GlobalConfig->writeEntry("Begin HTML","<font color=\"#202050\"><b>&gt;&gt;");
	GlobalConfig->writeEntry("End HTML","&lt;&lt;</b></font>");

	cfg.setGroup("Mailbox");
	QString source=cfg.readEntry("Mailbox");
	if(source=="Local")
		cfg.setGroup("Local Mail");
	else if(source=="POP3")
		cfg.setGroup("POP3");
	else
		cfg.setGroup("IMAP");
	
	QString accountName=cfg.readEntry("Server");
 	if(accountName.contains('.'))
 		accountName=accountName.replace(QRegExp("\\."),"_");
	
	// receive options
	GlobalConfig->setGroup("Receive Options");
	GlobalConfig->writeEntry("Interval", 300);
	GlobalConfig->writeEntry("UidCount", 10000);
	GlobalConfig->writeEntry("Accounts", accountName);
	GlobalConfig->writeEntry("Default", accountName);
	
	// send options
	GlobalConfig->setGroup("Send Options");
	GlobalConfig->writeEntry("Work offline", "No");
	GlobalConfig->writeEntry("Save sent", "Yes");
	
	GlobalConfig->setGroup(QString("Account ")+accountName);
	GlobalConfig->writeEntry("Enabled", "Yes");
	
	cfg.setGroup("Identity");
	GlobalConfig->writeEntry("From", cfg.readEntry("Email"));
	GlobalConfig->writeEntry("Name", cfg.readEntry("Name"));
	if(cfg.readEntry("Email")!=cfg.readEntry("Reply to"))
		GlobalConfig->writeEntry("Reply to", cfg.readEntry("Reply to"));
	GlobalConfig->writeEntry("Organization", cfg.readEntry("Organization"));
	cfg.setGroup("SMTP");
	GlobalConfig->writeEntry("Smtp", cfg.readEntry("Server"));
	GlobalConfig->writeEntry("SPort", cfg.readEntry("Port"));

	if(source=="Local")
	{
		// use local mailbox
		
		cfg.setGroup("Local Mail");
		GlobalConfig->writeEntry("Mailbox", cfg.readEntry("Mailbox"));
		GlobalConfig->writeEntry("Type", "MAILBOX");
	}
	else
		if(source=="POP3")
		{
			// use a POP3 account

			cfg.setGroup("POP3");
			GlobalConfig->writeEntry("Type", "POP3");
			GlobalConfig->writeEntry("User", cfg.readEntry("UserName"));
			GlobalConfig->writeEntry("Server", cfg.readEntry("Server"));
			GlobalConfig->writeEntry("Port", cfg.readEntry("Port"));
			GlobalConfig->writeEntry("Leave on server", cfg.readEntry("LeaveOnServer"));
			GlobalConfig->writeEntry("Sync", cfg.readEntry("RemoteDelete"));
			GlobalConfig->writeEntry("Persistence", cfg.readEntry("DeleteAfter"));
			GlobalConfig->writeEntry("Password", cfg.readEntry("Password"));
			GlobalConfig->writeEntry("Remember password", cfg.readEntry("RememberPassword"));
		}
		else
		{
			// use an IMAP account

			cfg.setGroup("IMAP");
			GlobalConfig->writeEntry("Type", "IMAP4");
			GlobalConfig->writeEntry("User", cfg.readEntry("UserName"));
			GlobalConfig->writeEntry("Server", cfg.readEntry("Server"));
			GlobalConfig->writeEntry("Port", cfg.readEntry("Port"));
			GlobalConfig->writeEntry("Password", cfg.readEntry("Password"));
			GlobalConfig->writeEntry("Remember password", cfg.readEntry("RememberPassword"));
//			GlobalConfig->writeEntry("Mailbox", cfg.readEntry("Mailbox"));
//			GlobalConfig->writeEntry("Leave on server", cfg.readEntry("LeaveOnServer"));
			
			QString IMAPfolder=cfg.readEntry("Server");
			if(IMAPfolder.contains('.'))
				IMAPfolder=IMAPfolder.replace(QRegExp("\\."),"_");
			
			// create an extra VFS folder
			GlobalConfig->setGroup("VFS /Magellan/Mail");
	    GlobalConfig->writeEntry("Subfolders", "/Magellan/Mail/Inbox,/Magellan/Mail/Outbox,/Magellan/Mail/Drafts,/Magellan/Mail/Saved Messages,/Magellan/Mail/Sent Mail,/Magellan/Mail/Deleted Messages,/Magellan/Mail/"+IMAPfolder);
			GlobalConfig->writeEntry("Flags", "c");
			
			GlobalConfig->setGroup("VFS /Magellan/Mail/"+IMAPfolder);
			GlobalConfig->writeEntry("Binding", "thisInstance");
			GlobalConfig->writeEntry("Type", "imap");
			GlobalConfig->writeEntry("Flags", "c");
	    GlobalConfig->writeEntry("MIME type", "");
	    GlobalConfig->writeEntry("View type", "genmail");
			GlobalConfig->writeEntry("Account", IMAPfolder);
	
	    // create the default INBOX folder
	    serverPath=QString("imap_")+IMAPfolder;
	    inboxFolder=QString("/Magellan/Mail/")+IMAPfolder+QString("/Inbox");
			GlobalConfig->writeEntry("Subfolders", inboxFolder);
			// the default IMAP mailbox - INBOX
    	GlobalConfig->setGroup("VFS "+inboxFolder);
    	GlobalConfig->writeEntry("Binding", "thisInstance");
    	GlobalConfig->writeEntry("Server Path", serverPath);
    	GlobalConfig->writeEntry("Type", "imap");
    	GlobalConfig->writeEntry("Flags", "c");
    	GlobalConfig->writeEntry("View type", "mail");
    	GlobalConfig->writeEntry("MIME type", "text/rfc822");
			GlobalConfig->writeEntry("Account", IMAPfolder);
			GlobalConfig->writeEntry("Mailbox", "INBOX");
		}
	
	// check if we should delete everything in the specified directory
	cfg.setGroup("Directory Exists");
	if(cfg.readEntry("Keep")=="No")
	{
		// delete all the Magellan-related stuff
		cfg.setGroup("Choose Dir");
		QString mdir=cfg.readEntry("Directory");
		
		QDir top(mdir);
		top.remove("syscontacts");
		top.remove("sysgroups");
		
		QDir data(mdir+"/internal");
		for(unsigned i=0;i<data.count();i++)
			data.remove(data[i]);
		
		data.setPath(mdir+"/sysnotes");
		for(unsigned i=0;i<data.count();i++)
			data.remove(data[i]);
		
		data.setPath(mdir+"/sysmail_inbox");
		for(unsigned i=0;i<data.count();i++)
			data.remove(data[i]);
		
		data.setPath(mdir+"/sysmail_outbox");
		for(unsigned i=0;i<data.count();i++)
			data.remove(data[i]);

	  data.setPath(mdir+"/sysmail_drafts");
		for(unsigned i=0;i<data.count();i++)
			data.remove(data[i]);		
		
	  data.setPath(mdir+"/sysmail_saved");
		for(unsigned i=0;i<data.count();i++)
			data.remove(data[i]);				
		
		data.setPath(mdir+"/sysmail_deleted");
		for(unsigned i=0;i<data.count();i++)
			data.remove(data[i]);

	  data.setPath(mdir+"/sysmail_sent");
		for(unsigned i=0;i<data.count();i++)
			data.remove(data[i]);	
	}
	
	// create the default directory/file structure
	cfg.setGroup("Choose Dir");
	QString mdir=cfg.readEntry("Directory");

	// debug
	printf("Creating directory structure...\n");

	QDir top(mdir);
	top.cdUp();
//	top.mkdir(mdir, true);
	top.setPath(mdir);
	
	top.mkdir("sysnotes");
	top.mkdir("sysmail_inbox");
	top.mkdir("sysmail_outbox");
	top.mkdir("sysmail_drafts");
	top.mkdir("sysmail_sent");
	top.mkdir("sysmail_deleted");
	top.mkdir("sysmail_saved");
	top.mkdir("internal");
	
	if(!serverPath.isEmpty() && !inboxFolder.isEmpty())
	{
		// create an extra IMAP folder
		top.mkdir(serverPath);
		// create the IMAP config file
   	GlobalConfig->setGroup("VFS "+inboxFolder);
    QFile f( mdir+"/"+serverPath+"/"+"config" );
    f.open( IO_WriteOnly );
    QDataStream s( &f );
    s << GlobalConfig->readEntry("Account");
    s << GlobalConfig->readEntry("Mailbox");
    f.close();
	}
	
	if(!QFileInfo(mdir+"/syscontacts").exists())
	{
		QFile contacts(mdir+"/syscontacts");
		contacts.open(IO_WriteOnly);
		contacts.close();
	}
	
	if(!QFileInfo(mdir+"/sysgroups").exists())
	{
		QFile groups(mdir+"/sysgroups");
		groups.open(IO_WriteOnly);
		groups.close();
	}

	// create version file
	QFile ver(mdir+"/.version");
	ver.open(IO_WriteOnly);
	QTextStream txt(&ver);
	txt<<RELEASE_VERSION;
	ver.close();

	// write the configuration
	GlobalConfig->sync();
		
	printf("Default configuration created.\n");
		
	return true;
}









