/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <stdio.h>
#include <unistd.h>
#include <kprocwrap.h>

ProcessRun::ProcessRun(QString name)
{
	init();
	if(name!=QString::null)
		progName=name;
}

bool ProcessRun::run(QString name)
{
	if(name!=QString::null)
		progName=name;
	if(progName==QString::null) return false;
	kp.setExecutable(progName);
	kp.start(KProcess::Block, KProcess::AllOutput);
	bool flag=kp.normalExit();
	#ifdef DEBUG_KPROC_WRAP
		printf(" %s\n",(const char *) stdOut);
		printf(" %s\n",(const char *) stdErr);
	#endif
	return flag;
}

void ProcessRun::init()
{
	connect(&kp, SIGNAL(receivedStdout(KProcess *, char *, int)), 
			SLOT(out(KProcess *, char *, int)));
	connect(&kp, SIGNAL(receivedStderr(KProcess *, char *, int)), 
			SLOT(err(KProcess *, char *, int)));
}

void ProcessRun::reset()
{
	stdErr.truncate(0);
	stdOut.truncate(0);
}


int ProcessRun::out(KProcess *kp, char *buffer, int buflen)
{
	#ifdef DEBUG_KPROC_WRAP
		printf("---------\n");
	#endif
	int buf=stdOut.length();
	stdOut.append(buffer);
	stdOut.truncate(buflen+buf);
	return 1;
}
int ProcessRun::err(KProcess *kp, char *buffer, int buflen)
{
	#ifdef DEBUG_KPROC_WRAP
		printf("----+----\n");
	#endif
	stdErr.append(buffer);
	stdErr.truncate(buflen);
	#ifdef DEBUG_KPROC_WRAP
		printf("err:%d\n",buflen);
	#endif
	return 1;
}

QString &ProcessRun::getError()  { return stdErr; }
QString &ProcessRun::getOutput() { return stdOut; }





