/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */
 
#ifndef KPROC_WRAP_HPP
#define KPROC_WRAP_HPP

#include <qobject.h>
#include <kprocess.h>
#include <qstring.h>


/**
	*		ProcessRun 
	*	@short class for running a process with the possibility of capturing
	* its stdout/stderr outputs
	*
	*	Purpose:
	*		Getting rid of the KProcess' signals when receiving some output from the
	* running file.
	*
	* Usage:
	*		For compiling, first do a "moc -o kprocwrap_moc.cpp kprocwrap.h". Then
	*	compile all the cpp files (kprocwrap_moc.cpp, kprocwrap.cpp) wilst including
	* Qt and KDE include/ dirs.
	*
	*		For linking it needs -lqt and -lkdecore (for KProcess).
	*
	*		For using within a C++ program, declare a ProcessRun object inside your
	* favourite class, and just use it as you like. The Qt event queue has to be
	* initialized, so do a QApplication or a KApplication in your main().
	*
	*		BEWARE: the program is executed via a BLOCKING method. If the program never ends,
	* the object will get stuck waiting.
  *
  * (laur)
	*
  */

class ProcessRun: public QObject
{
	Q_OBJECT
	public:
		/**
		 *	Constructor (default). It initializes the internal variables for usage.
		 * @param name the program's name. In fact, the string contains all the
		 * execution parameters too.
		 * If the name is NULL, then only the internal sturctures are initialized.
		 */
		ProcessRun(QString name=QString::null);
		/**
		 *	Method for launching the program.
		 * @param name the program's name with the same specification as the
		 * constructor. If null, the old name is kept. If the old name was null too,
		 * then an error is returned.
		 *
		 * @return true if the program was sucessfully executed, false otherwise.
		 */
		bool run(QString name=QString::null);
		/**
		 *	Method for intercepting the program's output on stdout.
		 * @return a QString containing the program's output on stdout.
		 */
		QString &getError();
		/**
		 *	Method for intercepting the program's output on stderr.
		 * @return a QString containing the program's output on stderr.
		 */
		QString &getOutput();
		/**
		 *	Method for cleaning stdout, stderr buffers of junk.
		 */
		void reset();
	public slots:
		int out(KProcess *kp, char *buffer, int buflen);
		int err(KProcess *kp, char *buffer, int buflen);
	private:
		// the init sequence
		void init();
		// the kprocess
		KProcess kp;
		// program's name + parameters
		QString progName;
		// program's stderr
		QString stdErr;
		// program's stdout
		QString stdOut;
	
};

#endif








