/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * $Id: composerwidget.h,v 1.2 2001/05/18 04:07:06 alex Exp $
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */
 
#ifndef __ComposerWidget__
#define __ComposerWidget__

#include <qwidget.h>
#include <qlayout.h>
#include <qsplitter.h>
#include <qstring.h>

#include <addresslistclass.h>
#include <composerattpane.h>
#include <composereditor.h>
#include <addressfieldedit.h>
#include <lineedit.h>

class ComposerWidget : public QWidget
{
	Q_OBJECT

	friend class ComposerWindow;

	public:
		ComposerWidget(ComposerWindow *parent, const char *name=0);
		virtual ~ComposerWidget();
		
		// address retrieval methods
		AddressListClass *toAddresses();
		AddressListClass *ccAddresses();
		AddressListClass *bccAddresses();
		
		// address set methods
		void setToAddresses(AddressListClass);
		void setCcAddresses(AddressListClass);
		void setBccAddresses(AddressListClass);

		// message body
		QString text();
		void setText(QString);
		
		// message subject
		QString subject();
		void setSubject(QString);

	public slots:
		// attachment pane
		void updateAttachmentPane();
		
		// signature
		void updateSignature();
		
		// bcc field
		void updateBccField();

	protected:
		QVBoxLayout *layout;
		QHBoxLayout *subjectLayout;
		QSplitter *attachmentSplitter;
		ComposerAttachmentPane *attachmentPane;
		AddressFieldEdit *toField, *ccField, *bccField;
		GenericFieldEdit *subjectField;
		ComposerEditor *editor;
		bool hasAttachments;
};

#endif
