/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef __ComposerWindow__
#define __ComposerWindow__

#include <lineedit.h>
#include <addresslistclass.h>
#include <qstring.h>
#include <composerattpane.h>
#include <kmainwindow.h>
#include <qtextbrowser.h>
#include <lsvariable.h>
#include <qdict.h>
#include <addresslineedit.h>
#include <qlayout.h>
#include <qsplitter.h>
#include <qmultilineedit.h>
#include <mainwindow.h>
#include <ebutton.h>
#include <qpopupmenu.h>
#include <toolbarseparator.h>
#include <qlabel.h>
#include <epopupbutton.h>
#include <composereditor.h>
#include <composerwidget.h>
#include <addressfieldedit.h>
#include <signatureviewer.h>

#define MENU_HIGHEST_PRIORITY 102
#define MENU_HIGH_PRIORITY 101
#define MENU_NORMAL_PRIORITY 100
#define MENU_LOW_PRIORITY 99
#define MENU_LOWEST_PRIORITY 98

class QTimer;

class ComposerWindow : public KMainWindow
{
	Q_OBJECT
	public:
		enum ComposeMode 
		{ 
			EditMessage=0, 
			Forward, 
			ForwardInline, 
			ForwardAsAttachment,
			ForwardQuoted,
			Reply, 
			ReplyAll, 
			SendObject, 
			UsingRecipient 
		};

		ComposerWindow();			
		~ComposerWindow();
				
		static void openComposer();
		static void openComposer(const QString &, ComposeMode);
		static void openComposer(const QStringList &, ComposeMode);
		
		bool isOffline();
		const QString getDefaultCharset() const;
	public slots:
		// send-related signals
		void sendUsingDefault();
		void sendUsing(int);
		void sendLaterUsingDefault();
		void sendLaterUsing(int);
		void sendDefault();
		
		// clipboard methods
		void cut();
		void copy();
		void paste();
		void clear();
		
		// text handling
		void quoteSelection();
		void unquoteSelection();
		void shiftLeft();
		void shiftRight();
		
		// insert a horizontal line
		void insertHLine();
		
		// toggle bullet mode
		void toggleBulletMode();
		
		// toggle numbering mode
		void toggleNumberingMode();
		
		// attachments
		void addFileAttachment();
		
		// priority
		void lowerPriority();
		void higherPriority();
		void setPriority(int);
		
		// insert file
		void insertFile();
		
		// save methods
		void saveAsDraft();
		void saveAsFile();
		void saveMessage();
		
		// import
		void importFromFile();
		
		// message scheduling
		void setScheduling();
		
		// signature transfer
		void transferSignature();
		
		// message properties (external component)
		void messageProperties();
		
		// signature manager (external component)
		void signatureManager();
		
		// spell checker (external component)
		void spellChecker();
	private slots:
		// internal slot used to set the title when the subject field gets changed
		void setTitle(const QString &);
	
		// internal slot used to acknowledge that the text has changed and needs saving
		void ackTextChanged();
		
		// internal slot used to acknowledge that the subject was changed
		void ackSubjectChanged(const QString &);
		
		void ackAddressChanged();
	
		// internal slot used to update the priority buttons tooltips
		void updatePriorityTips();
		
		// build account lists
		void buildAccountList();
		
		// internal slot for autosave
		void ackAutoSaveTimer();
	private:
		void closeEvent(QCloseEvent *);	
			
		// load message from server using messageID
		void loadMessage();
	
		void loadFromFwdSource(const QString &);
		void loadFromFwdSourceInline(const QString &);
		void loadFromFwdSourceQuoted(const QString &);
		void loadFromFwdSourceAsAttachment(const QString &);
		void loadFromFwdSource(const QStringList &);
		void loadFromRepSource(const QString &, bool replyAll=false);
		
		void loadObjectAsAttachment(const QString &);
		
		void initBasicMessage(const QString &, const QString &);
		void attachObject(const QString &, const QString &, const QString &, const QString &);
		void copyAttachmentsFrom(const QString &);
				
		// move message into Outbox (if needed)
		void saveToOutbox();
		
		// send message
		void sendMessage();
		
		// priority transform
		QString priorityToString(int);
		int priorityFromString(const QString &);
		
		bool canSend();
		
		QStringList accountList;
		QString sourceAccount;
		
		ComposerWidget *composerWidget;
		QPopupMenu *sendAccounts, *sendLaterAccounts;
		EPopupButton *sendButton;
		QPopupMenu *priority;
		EButton *higherPriorityButton, *lowerPriorityButton;
				
		ToolBarSeparator* toolSeparator(QWidget *parent, const char *name=0);

		QTimer *saveTimer;

		QString messageID;
		bool messageDirty;
		bool messageChanged;
		bool forcedClose;
		
		int messagePriority;
		QString scheduling;
		QStringList extendedStatus;
		QString account;
		
		static QList<ComposerWindow> composerList;
};

#endif
