/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <stdio.h>

#include <qpainter.h>
#include <qbitmap.h>
#include <qwidget.h>

#include <kiconloader.h>

#include <pixtoolbox.h>

#define IDSTRING "PixmapToolBox: "

/*
 *		The global PixmapToolBox object is declared here.
 */
PixmapToolBox ptb;

QPixmap PixmapToolBox::compoundPixmap(QPixmap back, QPixmap front, 
	PixmapToolBox::CompoundTypes cType)
{
	if(back.isNull() || front.isNull())
		return BarIcon("book-group");
	QPixmap result=back;
	if(cType==SuperPosition)
	{
		QBitmap bmp(back.width(), back.height());
		bmp.fill();
		result.setMask(bmp); // all is ok.
	}
	QPainter *p;
	p=new QPainter((QPaintDevice *)&result);
	p->setClipping(false);
	int dx=0, dy=0;
	switch (cType)
	{
		case SuperPosition:
			dx=back.width()-front.width();
			dy=back.height()-front.height();
			p->fillRect(0, 0, back.width(), back.height(), QBrush("white"));
			p->setRasterOp(Qt::AndROP);
			p->drawPixmap(0, 0, back);
			p->setRasterOp(Qt::CopyROP);
			p->drawPixmap(dx, dy, front);
			break;
		case ConcatenateLeft:
			dy=back.height()-front.height();
			result.resize(back.width()+front.width(), back.height());
			p->eraseRect(0, 0, result.width(), result.height());
			p->drawPixmap(0, 0, front);
			p->drawPixmap(front.width(), dy, back);
			break;
		case ConcatenateRight:
			dy=back.height()-front.height();
			result.resize(back.width()+front.width(), back.height());
			p->eraseRect(0, 0, result.width(), result.height());
			p->drawPixmap(0, dy, back);
			p->drawPixmap(back.width(), 0, front);
			break;
		case ConcatenateTop:
			dx=back.width()-front.width();
			result.resize(back.width(), front.height()+back.height());
			p->eraseRect(0, 0, result.width(), result.height());
			p->drawPixmap(0, 0, front);
			p->drawPixmap(dx, front.height(), back);
			break;
		case ConcatenateBottom:
			dx=back.width()-front.width();
			result.resize(back.width(), front.height()+back.height());
			p->eraseRect(0, 0, result.width(), result.height());
			p->drawPixmap(dx, 0, back);
			p->drawPixmap(0, back.height(), front);
			break;
		default:
			printf(IDSTRING"Error: Unknown composition type. Returning the original\n");
			result=back;
	}
//	p->end();
	delete p;
	return result;
}
QPixmap PixmapToolBox::scalePixmap(QPixmap original,
	double horz, double vert)
{
}

/**************************************************************************************/
MailPixmaps *MailPixmaps::instance=0;

QPixmap &MailPixmaps::getMailPixmap(int type)
{
	static QPixmap p;
	return p;
	printf("Querying for (%04x) -> %p\n",type, mails[type]);
	if(!mails[type]) return *mails[0];
	printf("Query ended\n");
	return *mails[type];
}
MailPixmaps *MailPixmaps::thisInstance()
{
	if(instance==0)
		instance=new MailPixmaps();
	return instance;
}
QPixmap MailPixmaps::compoundPixmap(QPixmap p1, QPixmap p2, QPixmap p3)
{
	QPixmap result;
	result.resize(p1.width() + p2.width() + p3.width(), p1.height());
	QPainter *p;
	p=new QPainter((QPaintDevice *)&result);
	p->eraseRect(0, 0, result.width(), result.height());
	p->drawPixmap(0,0,p1);
	p->drawPixmap(p1.width(),0,p2);
	p->drawPixmap(p1.width() + p2.width(),0,p3);
	delete p;
	return result;
}


MailPixmaps::MailPixmaps()
{
	// then build the pixmaps...
	QPixmap att[2];
	QPixmap envelopes[4];
	QPixmap priorities[5];
	att[0]=BarIcon("no-attachment");
	att[1]=BarIcon("attachment");
	envelopes[0]=BarIcon("normal-mail");
	envelopes[1]=BarIcon("forward-mail");
	envelopes[2]=BarIcon("reply-mail");
	envelopes[3]=BarIcon("reply-forward-mail");
	priorities[4]=BarIcon("lowest");
	priorities[3]=BarIcon("lower");
	priorities[2]=BarIcon("normal");
	priorities[1]=BarIcon("higher");
	priorities[0]=BarIcon("highest");

	QPixmap pix;
	return;
	pix=compoundPixmap(att[0], envelopes[0], priorities[0]);
	mails.insert(NoAttachmentIcon | NormalMailIcon | LowestPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[0], envelopes[0], priorities[1]);
	mails.insert(NoAttachmentIcon | NormalMailIcon | LowerPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[0], envelopes[0], priorities[2]);
	mails.insert(NoAttachmentIcon | NormalMailIcon | NormalPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[0], envelopes[0], priorities[3]);
	mails.insert(NoAttachmentIcon | NormalMailIcon | HigherPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[0], envelopes[0], priorities[4]);
	mails.insert(NoAttachmentIcon | NormalMailIcon | HighestPriorityIcon, new QPixmap(pix));

	pix=compoundPixmap(att[0], envelopes[1], priorities[0]);
	mails.insert(NoAttachmentIcon | ForwardMailIcon | LowestPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[0], envelopes[1], priorities[1]);
	mails.insert(NoAttachmentIcon | ForwardMailIcon | LowerPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[0], envelopes[1], priorities[2]);
	mails.insert(NoAttachmentIcon | ForwardMailIcon | NormalPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[0], envelopes[1], priorities[3]);
	mails.insert(NoAttachmentIcon | ForwardMailIcon | HigherPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[0], envelopes[1], priorities[4]);
	mails.insert(NoAttachmentIcon | ForwardMailIcon | HighestPriorityIcon, new QPixmap(pix));

	pix=compoundPixmap(att[0], envelopes[2], priorities[0]);
	mails.insert(NoAttachmentIcon | ReplyMailIcon | LowestPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[0], envelopes[2], priorities[1]);
	mails.insert(NoAttachmentIcon | ReplyMailIcon | LowerPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[0], envelopes[2], priorities[2]);
	mails.insert(NoAttachmentIcon | ReplyMailIcon | NormalPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[0], envelopes[2], priorities[3]);
	mails.insert(NoAttachmentIcon | ReplyMailIcon | HigherPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[0], envelopes[2], priorities[4]);
	mails.insert(NoAttachmentIcon | ReplyMailIcon | HighestPriorityIcon, new QPixmap(pix));

	pix=compoundPixmap(att[0], envelopes[3], priorities[0]);
	mails.insert(NoAttachmentIcon | ForwardReplyMailIcon | LowestPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[0], envelopes[3], priorities[1]);
	mails.insert(NoAttachmentIcon | ForwardReplyMailIcon | LowerPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[0], envelopes[3], priorities[2]);
	mails.insert(NoAttachmentIcon | ForwardReplyMailIcon | NormalPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[0], envelopes[3], priorities[3]);
	mails.insert(NoAttachmentIcon | ForwardReplyMailIcon | HigherPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[0], envelopes[3], priorities[4]);
	mails.insert(NoAttachmentIcon | ForwardReplyMailIcon | HighestPriorityIcon, new QPixmap(pix));

	pix=compoundPixmap(att[1], envelopes[0], priorities[0]);
	mails.insert(AttachmentIcon | NormalMailIcon | LowestPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[1], envelopes[0], priorities[1]);
	mails.insert(AttachmentIcon | NormalMailIcon | LowerPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[1], envelopes[0], priorities[2]);
	mails.insert(AttachmentIcon | NormalMailIcon | NormalPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[1], envelopes[0], priorities[3]);
	mails.insert(AttachmentIcon | NormalMailIcon | HigherPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[1], envelopes[0], priorities[4]);
	mails.insert(AttachmentIcon | NormalMailIcon | HighestPriorityIcon, new QPixmap(pix));

	pix=compoundPixmap(att[1], envelopes[1], priorities[0]);
	mails.insert(AttachmentIcon | ForwardMailIcon | LowestPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[1], envelopes[1], priorities[1]);
	mails.insert(AttachmentIcon | ForwardMailIcon | LowerPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[1], envelopes[1], priorities[2]);
	mails.insert(AttachmentIcon | ForwardMailIcon | NormalPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[1], envelopes[1], priorities[3]);
	mails.insert(AttachmentIcon | ForwardMailIcon | HigherPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[1], envelopes[1], priorities[4]);
	mails.insert(AttachmentIcon | ForwardMailIcon | HighestPriorityIcon, new QPixmap(pix));

	pix=compoundPixmap(att[0], envelopes[2], priorities[0]);
	mails.insert(AttachmentIcon | ReplyMailIcon | LowestPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[0], envelopes[2], priorities[1]);
	mails.insert(AttachmentIcon | ReplyMailIcon | LowerPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[0], envelopes[2], priorities[2]);
	mails.insert(AttachmentIcon | ReplyMailIcon | NormalPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[0], envelopes[2], priorities[3]);
	mails.insert(AttachmentIcon | ReplyMailIcon | HigherPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[0], envelopes[2], priorities[4]);
	mails.insert(AttachmentIcon | ReplyMailIcon | HighestPriorityIcon, new QPixmap(pix));

	pix=compoundPixmap(att[0], envelopes[3], priorities[0]);
	mails.insert(AttachmentIcon | ForwardReplyMailIcon | LowestPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[0], envelopes[3], priorities[1]);
	mails.insert(AttachmentIcon | ForwardReplyMailIcon | LowerPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[0], envelopes[3], priorities[2]);
	mails.insert(AttachmentIcon | ForwardReplyMailIcon | NormalPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[0], envelopes[3], priorities[3]);
	mails.insert(AttachmentIcon | ForwardReplyMailIcon | HigherPriorityIcon, new QPixmap(pix));
	pix=compoundPixmap(att[0], envelopes[3], priorities[4]);
	mails.insert(AttachmentIcon | ForwardReplyMailIcon | HighestPriorityIcon, new QPixmap(pix));

}


