/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */


#ifndef __PixToolBox__
#define __PixToolBox__

#include <qstringlist.h>
#include <qpixmap.h>
#include <qintdict.h>


// class for pixmap operations
class PixmapToolBox
{
	public:
	enum CompoundTypes { SuperPosition=0, 
			ConcatenateLeft, 
			ConcatenateRight,
			ConcatenateTop,
			ConcatenateBottom};
	QPixmap compoundPixmap(QPixmap back, QPixmap front, CompoundTypes cType=SuperPosition);
	/*
	 *	Scale has some default values for horz, vert meaning proportional scaling
	 */
	QPixmap scalePixmap(QPixmap original, double horz=-1.0, double vert=-1.0);
};


class MailPixmaps
{
	public:
		enum
		{
			NoAttachmentIcon=0x0000,
			AttachmentIcon=0x0001
		};
		enum
		{
			LowestPriorityIcon=0x0000 << 4,
			LowerPriorityIcon=0x0001 << 4,
			NormalPriorityIcon=0x0002 << 4,
			HigherPriorityIcon=0x0003 << 4,
			HighestPriorityIcon=0x00004 << 4
		};
		enum{
			NormalMailIcon=0x0000 << 1,
			ForwardMailIcon=0x0001 << 1,
			ReplyMailIcon=0x0002 << 1,
			ForwardReplyMailIcon=0x0003 << 1
		};
		QPixmap &getMailPixmap(int types=0);
		static MailPixmaps *thisInstance();
		MailPixmaps();
	private:
		QPixmap compoundPixmap(QPixmap p1, QPixmap p2, QPixmap p3);
		static MailPixmaps *instance;
		QIntDict<QPixmap> mails;
};

#endif
