/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal 
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <qlayout.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qtextview.h>
#include <qcheckbox.h>
#include <qprogressbar.h>
#include <qstringlist.h>
#include <qtimer.h>

#include <kconfig.h>
#include <kiconloader.h>
#include <khtmlview.h>
#include <khtml_part.h>

#include <clientrmi.h>
#include <sendreceivedialog.h>

#include <stdio.h>

extern KConfig *GlobalConfig;

SendReceiveDialog::SendReceiveDialog(QWidget *parent, const char *name):SendReceiveDialogBase(parent, name)
{
	logView=new KHTMLPart(this);
	logView->autoloadImages(true);
	logView->view()->setGeometry(QRect(10, 140, 471, 141));
	logView->show();

	pinToggleButton->setPixmap(BarIcon("pin-blue-off"));
	connect(pinToggleButton, SIGNAL(toggled(bool)), this, SLOT(setPinPixmap(bool)));
		
	sendLabel->setText(QString::null);
	receiveLabel->setText(QString::null);
	
	pop3InProgress=false;
	smtpInProgress=false;
}

void SendReceiveDialog::start()
{
	smtpInProgress=true;
	pop3InProgress=true;
	
	clearLog();
	GlobalConfig->setGroup("Receive Options");
	if (GlobalConfig->readEntry("Display progress") != "No")
		show();
}

void SendReceiveDialog::end()
{
	if(smtpInProgress || pop3InProgress) return;
	
  if(dontShowCheckbox->isChecked())
  {
    GlobalConfig->setGroup("Receive Options");
    GlobalConfig->writeEntry("Display progress", "No");
  }

  if (!pinToggleButton->isOn())
	QTimer::singleShot(1500, this, SLOT(hide()));
}

void SendReceiveDialog::showProgress(const QString &message)
{
  QStringList info=QStringList::split(":", message);

  if(info[0]=="pop3")
  {
    if(info[1]=="task")
    {
      appendInfo(QString("Receiving mail on account ")+info[2]);
    }
    else if(info[1]=="connect")
    {
      receiveLabel->setText("Connecting to server...");
      receiveProgressBar->setProgress(0);
    }
    else if(info[1]=="list")
    {
      receiveLabel->setText("Receiving list of messages...");
    }
    else if(info[1]=="messages")
    {
      receiveProgressBar->setTotalSteps(info[2].toInt());

    }
    else if(info[1]=="nomessages")
    {
      receiveLabel->setText("There are no new messages on the server");
    }
    else if(info[1]=="dl")
    {
      receiveLabel->setText(QString("Downloading message ")+info[2]+"/"+info[4]);
      receiveProgressBar->setProgress(info[2].toInt());
    }
    else if(info[1]=="sync")
    {
      receiveLabel->setText("Checking for messages to delete...");
    }
    else if(info[1]=="completed")
    {
      appendInfo("Receive completed");
      receiveLabel->setText("Download complete");
      receiveProgressBar->setProgress(0);
			pop3InProgress=false;
      end();
    }
    else if(info[1]=="err")
    {
      appendError(QString("Received failed with the error: ")+info[2]);
      receiveLabel->setText("Connection failed");
      receiveProgressBar->setProgress(0);
			pop3InProgress=false;
      end();
    }
  }
  else if(info[0]=="smtp")
  {
    if(info[1]=="task")
    {
      appendInfo(QString("Sending mail on account ")+info[2]);
    }
		else if(info[1]=="sending")
		{
			sendProgressBar->setTotalSteps(info[3].toInt());
			sendProgressBar->setProgress(info[2].toInt()-1);
		}
    else if(info[1]=="sent")
    {
      sendProgressBar->setTotalSteps(info[3].toInt());
      sendProgressBar->setProgress(info[2].toInt());
    }
    else if(info[1]=="err")
    {
      appendError(QString("Send failed with the error: ")+info[2]);
			smtpInProgress=false;
			end();
    }
    else if(info[1]=="done")
    {
      appendInfo("Send completed");
			smtpInProgress=false;
			end();
    }
  }
}

void SendReceiveDialog::hideProgress()
{
  hide();
}

void SendReceiveDialog::stopDelivery()
{
  ClientRMI::ref()->stopPOP3Delivery();
}

void SendReceiveDialog::appendInfo(const QString &message)
{
	return appendString(message, "progress-ok.png");
}

void SendReceiveDialog::appendError(const QString &message)
{
	return appendString(message, "progress-error.png");
}

void SendReceiveDialog::appendString(const QString &message, const QString &image)
{
	log.append(QString("<table>") +
				"<tr>" +
						"<td valign=\"top\"><img src=\"" + image + "\"></td>" +
						"<td valign=\"top\">" + message + "</td>" +
				"</tr>" +
			"</table>" +
			"<br>");

	writeLog();	
}

void SendReceiveDialog::clearLog()
{
	log="";
}

void SendReceiveDialog::writeLog()
{
	logView->begin();
	logView->write((const char *)(QString("<html><body>") + log + "</body></html>"));
	logView->end();
}

void SendReceiveDialog::setPinPixmap(bool isOn)
{
	if(isOn) pinToggleButton->setPixmap(BarIcon("pin-blue-on"));
	else 	pinToggleButton->setPixmap(BarIcon("pin-blue-off"));
}
