/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <textlabel.h>

TextLabel::TextLabel (QWidget *parent, const char *name, WFlags f)
	: QLabel(parent, name, f), TextFitter()
{
}

TextLabel::TextLabel(const QString &text, QWidget *parent, const char *name, WFlags f)
	: QLabel(QString::null, parent, name, f), TextFitter()
{
	setText(text);
}

TextLabel::TextLabel(QWidget *buddy, const QString &text, QWidget *parent, const char *name, WFlags f)
	: QLabel(buddy, QString::null, parent, name, f),TextFitter()
{
	setText(text);
}

void TextLabel::setText(const QString &text)
{
	origText=text;
	QLabel::setText(fitText(text, width(), font()));
}

QString TextLabel::text()
{
	return origText;
}

void TextLabel::resizeEvent(QResizeEvent *e)
{
	setText(fitText(origText, e->size().width(), font()));
	QLabel::resizeEvent(e);
}
