/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <stdio.h>
#include <alarmlist.h>

#ifdef IDSTRING
	#undef IDSTRING
#endif

#define IDSTRING "AlarmList: "

#define TIMERINTERVAL	1000

#define DEBUG_ALARMLIST

AlarmList::AlarmList(QObject *parent, QDateTime ref)
{
#ifdef DEBUG_ALARMLIST
	printf(IDSTRING"Initializing the alarm list timer.\n");
#endif
	timer= new QTimer(parent,"QTimer 1");
	connect(timer,SIGNAL(timeout()), SLOT(tick()));
	timer->start(TIMERINTERVAL);
#ifdef DEBUG_ALARMLIST
	printf(IDSTRING"Done.\n");
#endif
	reference=ref;
}


AlarmList::~AlarmList()
{
	timer->stop();
#ifdef DEBUG_ALARMLIST
	printf(IDSTRING"Timer stopped.\n");
#endif
	delete timer;
}


void AlarmList::addAlarm(VAlarm *va)
{
	AlarmCouple couple;
	if(va->initTrigger(reference))
	{
		couple.alarm=va;
		couple.current=va->getTrigger();
		printf(IDSTRING"Added alarm with the following trigger: \"%s\".\n",
			(const char *)couple.current.toString());
	}	
}


void AlarmList::show()
{
}
void AlarmList::tick()
{
	QDateTime dt=reference;
	reference=dt.addSecs(TIMERINTERVAL/1000);
	printf(IDSTRING"tick @ %s\n",(const char *)reference.toString());
}




