/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <stdio.h>
#include <rdate.h>

#include <qstringlist.h>
#include <miscfunctions.h>
#include <toolbox.h>

#define IDSTRING "RDate: "

//#define DEBUG_RDATE

Period RDate::Finished;

extern Toolbox tb;

void RDate::parseString(const QString &dateTimeString)
{
	QStringList items=enhancedSplit(dateTimeString,',',QStringList());
	for(unsigned int i=0;i<items.count();i++)
	{
#ifdef DEBUG_RDATE
		Period p;
		printf(IDSTRING"ParseString: [%d] \"%s\"\n",i,(const char *)items[i]);
		p=tb.parseString(items[i]);
#endif
		dateOnly=false;
		if(items[i].find('T')==-1) dateOnly=true;
		periods.append(tb.parseString(items[i]));
#ifdef DEBUG_RDATE
		printf(IDSTRING"[%d].isDate=%d\n",i,dateOnly);
		printf(IDSTRING"[%d].finished=%d\n",i,p.isFinished);
		printf(IDSTRING"[%d].start=%s\n",i,(const char *)p.start.toString());
		printf(IDSTRING"[%d].offset=%d\n",i,p.length);
#endif
	} //for
}

void RDate::setType(RDate::DateType newType)
{
	type=newType;
}

void RDate::setFinshed()
{
	Finished.isFinished=true;
}

RDate::RDate(const QString &str, RDate::DateType t)
{
	setType(t);
	parseString(str);
}


int RDate::getNextOccurencePrivate(const QDateTime &today)
{
	for(unsigned int i=0;i<periods.count();i++)
	{
		if(dateOnly)
		{
			if(today.date()<=periods[i].start.date())
			{
#ifdef DEBUG_RDATE
				printf(IDSTRING"netNO: (date only) returning [%d]...\n",i); 
#endif
				return i;
			}
		}
		else
		{
			/**
			 *	If is a period, I'm returning the Period structure so "today"
			 */
			if(periods[i].length)
			{
				QDateTime tempDate=periods[i].start.addSecs(periods[i].length);
				if(today>=periods[i].start && today<=tempDate)
				{
#ifdef DEBUG_RDATE
				printf(IDSTRING"netNO: (interval) returning [%d]...\n",i); 
#endif
					return i;
				}
			}
			if(today<=periods[i].start)
			{
#ifdef DEBUG_RDATE
				printf(IDSTRING"netNO: (date/time) returning [%d]...\n",i); 
#endif
				return i;
			}
		}
	} //for
	return -1;
}

Period RDate::getNextOccurence(const QDateTime &today)
{
	int result = getNextOccurencePrivate(today);
	if (result == 1)
		return Finished;
	return periods[result];
}


Period RDate::getPreviousOccurence(const QDateTime &today)
{
	int result=getNextOccurencePrivate(today);
	if (result <= 0)
		return Finished;
	return periods[result-1];
}




