/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <rrule.h>
#include <toolbox.h>
#include <miscfunctions.h>
#include <stdio.h>
#include <stdlib.h>


#define IDSTRING "RRule: "

//#define DEBUG_RRULE
//#define DEBUG_RRULE_2


// This are the static variables for RRULE!
QStringList RRule::weekdayAbbreviations;
bool RRule::abbreviationsInitialized=false;

extern Toolbox tb;

void RRule::initWeekdayString()
{
	if(abbreviationsInitialized==false)
	{
		weekdayAbbreviations.append("MO");
		weekdayAbbreviations.append("TU");
		weekdayAbbreviations.append("WE");
		weekdayAbbreviations.append("TH");
		weekdayAbbreviations.append("FR");
		weekdayAbbreviations.append("SA");
		weekdayAbbreviations.append("SU");
		abbreviationsInitialized=true;
	}
}

QString RRule::weekDayToString(int weekday)
{
	return weekdayAbbreviations[weekday%7];
}
int RRule::weekDayToInt(QString weekday)
{
	for(int i=0;i<7;i++)
		if(weekdayAbbreviations[i].find(weekday,0,false)!=-1) return i;
	return 0;
}

QValueList<int> RRule::parseStringInt(QString str)
{
	QValueList<int> result;
	QStringList temp=enhancedSplit(str,',');
	for(int i=0;i<temp.count();i++)
		result.append(atoi((const char *)temp[i]));
	return result;
}

#define len	temp[i].length()
QValueList<ByDay> RRule::parseStringByDay(QString str)
{
	QValueList<ByDay> result;
	QStringList temp=enhancedSplit(str,',');
	for(int i=0;i<temp.count();i++)
	{
		ByDay bd;
		if(len>2)
			bd.value=atoi((const char *)temp[i].mid(0,len-2));
		else
			bd.value=1;
		bd.literal=temp[i].mid(len-2,2);
		result.append(bd);
#ifdef DEBUG_RRULE
		printf(IDSTRING"ByDay: (%d,<%s>)\n",bd.value, (const char *)bd.literal);
#endif
	}
	return result;
}

QStringList RRule::parseStringString(QString str)
{
	return enhancedSplit(str,',');
}
void RRule::matchList(QString title, QString list)
{
#ifdef DEBUG_RRULE
	printf(IDSTRING"Matching %s...\n",(const char *)title);
#endif
	if(title.find("until",0,false)!=-1)
	{
		Toolbox::TimeZone tz;
		endDate=tb.getDateTime(list,tz);
		endDateValid=true;
		return;
	}
	if(title.find("freq",0,false)!=-1)
	{
		frequency=list;
		return;
	}
	if(title.find("count",0,false)!=-1)
	{
		count=atoi((const char*)list);
		return;
	}
	if(title.find("interval",0,false)!=-1)
	{
		interval=atoi((const char*)list);
		return;
	}
	if(title.find("bysecond",0,false)!=-1)
	{
		bySecondList=parseStringInt(list);
		return;
	}
	if(title.find("byminute",0,false)!=-1)
	{
		byMinuteList=parseStringInt(list);
		return;
	}
	if(title.find("byhour",0,false)!=-1)
	{
		byHourList=parseStringInt(list);
		return;
	}
	if(title.find("byday",0,false)!=-1)
	{
		byDayList=parseStringByDay(list);
		return;
	}
	if(title.find("bymonthday",0,false)!=-1)
	{
		byMonthDayList=parseStringInt(list);
		return;
	}
	if(title.find("byyearday",0,false)!=-1)
	{
		byYearDayList=parseStringInt(list);
		return;
	}
	if(title.find("byweekno",0,false)!=-1)
	{
		byWeekNoList=parseStringInt(list);
		return;
	}
	if(title.find("bymonth",0,false)!=-1)
	{
		byMonthList=parseStringInt(list);
		return;
	}
	if(title.find("bysetpos",0,false)!=-1)
	{
		bySetPosList=parseStringInt(list);
		return;
	}
	if(title.find("wkst",0,false)!=-1)
	{
		byWeekDayList=parseStringString(list);
		return;
	}
}


void RRule::parseString(QString str)
{
	QStringList parts=enhancedSplit(str,';');
	// getting the frequency thing
	for(int i=0;i<parts.count();i++)
	{
		QStringList temp=enhancedSplit(parts[i],'=');
		matchList(temp[0], temp[1]);
	}
}


RRule::RRule(QString rrule)
{
	endDateValid=false;
	count=-1;
	interval=-1;
	initWeekdayString();
	parseString(rrule);
}


Occurences RRule::getAllOccurences(QDateTime dt, bool dateOnly)
{
	Occurences occ;
	#define adj			1
	
	#define L_year				dt.date().year()
	#define L_month				dt.date().month()
	#define L_dayOfMonth	dt.date().day()
	#define L_dayOfWeek		dt.date().dayOfWeek()
	#define L_dayOfYear		dt.date().dayOfYear()
	#define L_hour				dt.time().hour()
	#define L_minute			dt.time().minute()
	#define L_second			dt.time().second()

	QValueList<QDate> d1,d2;
	int number=0,offset=0;
	/** First I'm generating how many items i need by the trigger */
	if(frequency.find("yearly",0,false)!=-1)
	{
#ifdef DEBUG_RRULE
		printf(IDSTRING"Yearly trigger: %d\n",number);
#endif
		number=dt.date().daysInYear()-L_dayOfYear+adj;
		offset=L_dayOfYear-1;
	}
	if(frequency.find("monthly",0,false)!=-1)
	{
#ifdef DEBUG_RRULE
		printf(IDSTRING"Monthly trigger: %d\n",number);
#endif
		number=dt.date().daysInMonth()-L_dayOfMonth+adj;
		offset=L_dayOfMonth-1+QDate(L_year,L_month,1).dayOfYear()-1;
	}
	if(frequency.find("weekly",0,false)!=-1)
	{
#ifdef DEBUG_RRULE
		printf(IDSTRING"Weekly trigger: %d\n",number);
#endif
		number=7-L_dayOfWeek+adj;
		offset=L_dayOfYear-1;
	}
	// Generating elements...
#ifdef DEBUG_RRULE
	printf(IDSTRING"Generating %d occurences (theoretical).\n",number);
#endif
	for(int i=0;i<number;i++)
	{
		QDate date=QDate(L_year,1,1).addDays(i+offset);
			d1.append(QDate(L_year,1,1).addDays(i+offset));
#ifdef DEBUG_RRULE_2
			printf(" Added :%s\n",(const char *)d1[i].toString());
#endif
	}
/*****************************************************************************/
/* Now we will extract the matching things from the list                     */
/*****************************************************************************/

//////////////////////////////////////////////// BYMONTH
	if(!byMonthList.isEmpty())
	{
		for(int j=0;j<d1.count();j++)
			for(int i=0;i<byMonthList.count();i++)
				if(d1[j].month()==byMonthList[i])
					d2.append(d1[j]);
		d1=d2;
		d2.clear();
#ifdef DEBUG_RRULE
		printf(IDSTRING"After BYMONTH filtering %d occurences remaining\n",
			d1.count());
#endif
	}
//////////////////////////////////////////////// BYYEARDAY
	if(!byYearDayList.isEmpty())
	{
		for(int j=0;j<d1.count();j++)
			for(int i=0;i<byYearDayList.count();i++)
				if(d1[j].dayOfYear()==byYearDayList[i])
					d2.append(d1[j]);
		d1=d2;
		d2.clear();
#ifdef DEBUG_RRULE
		printf(IDSTRING"After BYYEARDAY filtering %d occurences remaining\n",
			d1.count());
#endif
	}

//////////////////////////////////////////////// BYWEEKNO
// The "offset" should transform the weeks accordingly
	if(!byWeekNoList.isEmpty())
	{
		int offset=QDate(L_year,1,1).dayOfWeek();
		for(int j=0;j<d1.count();j++)
			for(int i=0;i<byWeekNoList.count();i++)
				if(((d1[j].dayOfYear()-offset)/7+1)==byWeekNoList[i])
					d2.append(d1[j]);
		d1=d2;
		d2.clear();
#ifdef DEBUG_RRULE
		printf(IDSTRING"After BYWEEKNO filtering %d occurences remaining\n",
			d1.count());
#endif
	}
	
//////////////////////////////////////////////// BYWKST
	if(!byWeekDayList.isEmpty())
	{
		for(int j=0;j<d1.count();j++)
			for(int i=0;i<byWeekDayList.count();i++)
				if(d1[j].dayOfWeek()==(weekDayToInt(byWeekDayList[i])+1))
					d2.append(d1[j]);
		d1=d2;
		d2.clear();
#ifdef DEBUG_RRULE
		printf(IDSTRING"After BYWKST filtering %d occurences remaining\n",
			d1.count());
#endif
	}

#ifdef DEBUG_RRULE_2
	for(int i=0;i<d1.count();i++)
		printf(" Added :%s\n",(const char *)d1[i].toString());
#endif
//////////////////////////////////////////////// BYDAY
	if(!byDayList.isEmpty())
	{
		for(int i=0;i<byDayList.count();i++)
		{
			int counter=0;
			if(byDayList[i].value>0)
			{
				for(int j=0;j<d1.count();j++)
				{
					if(d1[j].dayOfWeek()==(weekDayToInt(byDayList[i].literal)+1))
						counter ++;
					if(counter==byDayList[i].value)
					{
#ifdef DEBUG_RRULE
						printf(IDSTRING"Appended %s (1)\n", (const char *)d1[j].toString());
#endif
						d2.append(d1[j]);
						j=d1.count(); // forcing out of the loop
					}
				}
			}
			else
			{
				for(int j=d1.count()-1;j>=0;j--)
				{
					if(d1[j].dayOfWeek()==(weekDayToInt(byDayList[i].literal)+1))
						counter --;
					if(counter==byDayList[i].value)
					{
#ifdef DEBUG_RRULE
						printf(IDSTRING"Appended %s (2)\n", (const char *)d1[j].toString());
#endif
						d2.append(d1[j]);
						j=-1; // forcing out of the loop
					}
				}
			}
		} // for
		d1=d2;
		d2.clear();
#ifdef DEBUG_RRULE
		printf(IDSTRING"After BYDAY (month) filtering %d occurences remaining\n",
			d1.count());
#endif
	}
	occ.dates=d1;
	d1.clear();
	
/******** Not ok if is only a time thing (HOURLY for example) **************
	if(occ.dates.isEmpty())
	{
#ifdef DEBUG_RRULE
		printf(IDSTRING"No occurences left in this triggering\n");
#endif
		return occ;
	}
****************************************************************************/

/************************ DATE PROCESSING FINISHED! ************************/
// THE SECONDS ARE IGNORED IN THIS VERSION !!!!
	QValueList<QTime> qt1,qt2;
	if(byHourList.isEmpty())
	{
		// for each hour
		if(dateOnly)
			qt1.append(QTime(0,0,0));
		else
			for(int i=0;i<24;i++)
				qt1.append(QTime(i,0,0));
	}
	else
	{
		for(int i=0;i<byHourList.count();i++)
			qt1.append(QTime(byHourList[i],0,0));
	}
#ifdef DEBUG_RRULE
		printf(IDSTRING" %d hour occurences.\n",qt1.count());
#endif
	// next, for each hour i generate the minute(s) instances (if any)
	
	if(!byMinuteList.isEmpty())
	{
		for(int i=0;i<qt1.count();i++)
			for(int j=0;j<byMinuteList.count();j++)
				qt2.append(qt1[i].addSecs(byMinuteList[j]*TOOLBOX_MINUTE));
		qt1=qt2; qt2.clear();
	}
	occ.times=qt1;
#ifdef DEBUG_RRULE_2
	for(int i=0;i<occ.dates.count();i++)
		printf(IDSTRING"Added (Date):%s\n",(const char *)occ.dates[i].toString());
	for(int i=0;i<occ.times.count();i++)
		printf(IDSTRING"Added (time):%s\n",(const char *)occ.times[i].toString());
#endif

	#undef year
	#undef month
	#undef dayOfMonth
	#undef dayOfWeek
	#undef dayOfYear
	#undef hour
	#undef minute
	#undef second
	return occ;
}

QValueList<QDateTime> RRule::getOccurences(QDateTime dt, bool dateOnly)
{
	QValueList<QDateTime> result;
	QValueList<QDateTime> result1;
	
	// unify the occurences
	result.clear();
	result1.clear();
	if(interval>0)
	{
		if(frequency.find("yearly",0,false)!=-1)
		{
#ifdef DEBUG_RRULE
			printf(IDSTRING"Yearly trigger.\n");
#endif
			if(((referenceDate.date().year()-dt.date().year()) % interval) != 0)
			{
				printf(" This year (%d) no events will occur.\n",
					dt.date().year());
				return result; // this is a void list!
			}
		}
		if(frequency.find("monthly",0,false)!=-1)
		{
#ifdef DEBUG_RRULE
			printf(IDSTRING"Monthly trigger.\n");
#endif
			if(((referenceDate.date().month()-dt.date().month()) % interval) != 0)
			{
				printf(" This month (%d) no events will occur.\n",
					dt.date().month());
				return result; // this is a void list!
			}
		}
		if(frequency.find("dayly",0,false)!=-1)
		{
#ifdef DEBUG_RRULE
			printf(IDSTRING"Dayly trigger.\n");
#endif
			if(((referenceDate.date().day()-dt.date().day()) % interval) != 0)
			{
				printf(" This day (%d) no events will occur.\n",
					dt.date().day());
				return result; // this is a void list!
			}
		}
		if(frequency.find("hourly",0,false)!=-1)
		{
#ifdef DEBUG_RRULE
			printf(IDSTRING"Hourly trigger.\n");
#endif
			if(((referenceDate.time().hour()-dt.time().hour()) % interval) != 0)
			{
				printf(" This hour (%d) no events will occur.\n",
					dt.time().hour());
				return result; // this is a void list!
			}
		}
		if(frequency.find("minutely",0,false)!=-1)
		{
#ifdef DEBUG_RRULE
			printf(IDSTRING"Minutely trigger.\n");
#endif
			if(((referenceDate.time().minute()-dt.time().minute()) % interval) != 0)
			{
				printf(" This minute (%d) no events will occur.\n",
					dt.time().minute());
				return result; // this is a void list!
			}
		}
		if(frequency.find("secondly",0,false)!=-1)
		{
#ifdef DEBUG_RRULE
			printf(IDSTRING"Secondly trigger.\n");
#endif
			if(((referenceDate.time().second()-dt.time().second()) % interval) != 0)
			{
				printf(" This second (%d) no events will occur.\n",
					dt.time().second());
				return result; // this is a void list!
			}
		}
	}
	Occurences oc=getAllOccurences(dt, dateOnly);
	if(oc.dates.count()==0)
		oc.dates.append(dt.date());
	if(oc.times.count()==0)
		oc.times.append(dt.time());
	for(int i=0;i<oc.dates.count();i++)
		for(int j=0;j<oc.times.count();j++)
			result.append(QDateTime(oc.dates[i],oc.times[j]));
/* Don't check the restrictions here. They are checked in getGlobalOccs...
#ifdef DEBUG_RRULE
	printf(IDSTRING"Total %d occurences before restrictions\n",result.count());
#endif
	if(endDateValid)
	{
#ifdef DEBUG_RRULE
		printf(IDSTRING"grep-ing the end date...\n");
#endif
		for(int i=0;i<result.count();i++)
		{
#ifdef DEBUG_RRULE_2
			printf("<%s> vs. <%s>\n",
				(const char *)result[i].toString(),(const char *)endDate.toString());
#endif
			if(result[i]<endDate)
				result1.append(result[i]);
		}
		result=result1;
		result1.clear();
	}
	if(count>0)
	{
#ifdef DEBUG_RRULE
		printf(IDSTRING"grep-ing the count (%d)...\n", result.count());
#endif
		if(count<result.count())
			for(int i=0;i<count;i++) result1.append(result[i]);
		result=result1;
		result1.clear();
	}
#ifdef DEBUG_RRULE
	printf(IDSTRING"Total %d occurences after restrictions\n",result.count());
#endif
****************************************************************************/
	return result;
}

QValueList<QDateTime> RRule::getGlobalOccurences(
		QDateTime reference, QDateTime dt, bool dateOnly)
{
	QDateTime i=reference;
	QDateTime bak=referenceDate;
	referenceDate=reference;
	QValueList<QDateTime> result;
	QValueList<QDateTime> result1;
	while(i.date().year()<=dt.date().year())
	{
		result+=getOccurences(i, dateOnly);
		QDateTime tmp=i;
		i.setDate(QDate(tmp.date().year()+1,tmp.date().month(),tmp.date().day()));
	}
	// if the month is lesser than the reference month
	// or months are equal and the days are in the same relation
//	if((dt.date().month()<i.date().month()) ||
//			((dt.date().month()<i.date().month()) &&
//			 (dt.date().day()<i.date().day())))
//		result+=getOccurences(dt);
//	printf(IDSTRING"occs: %d\n",result.count());
	if(endDateValid)
	{
#ifdef DEBUG_RRULE
		printf(IDSTRING"grep-ing the end date...\n");
#endif
		for(int i=0;i<result.count();i++)
		{
#ifdef DEBUG_RRULE_2
			printf("<%s> vs. <%s>\n",
				(const char *)result[i].toString(),(const char *)endDate.toString());
#endif
			if(result[i]<endDate)
				result1.append(result[i]);
		}
		result=result1;
		result1.clear();
	}
	if(count>0)
	{
#ifdef DEBUG_RRULE
		printf(IDSTRING"grep-ing the count...\n");
#endif
		if(count<result.count())
			for(int i=0;i<count;i++) result1.append(result[i]);
		result=result1;
		result1.clear();
	}
	referenceDate=bak;
#ifdef DEBUG_RRULE
	printf(IDSTRING"Total %d occurences after restrictions\n",result.count());
#endif
	return result;
}





