/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <timezones.h>
#include <qvaluelist.h>
#include <metaobject.h>
#include <qlist.h>

#define IDSTRING	"TimeZones: "

//#define TZ_DEBUG
TimeZones::TimeZones(QValueList<MetaObject*> zones, int yr, TimeZones::TZPolicy pol)
{
#ifdef TZ_DEBUG
	printf(IDSTRING"default constructor\n");
#endif
	setPolicy(pol);
	setYear(yr);
	for(int i=0;i<zones.count();i++)
	{
#ifdef TZ_DEBUG
		printf(IDSTRING"Adding zone <%s>\n", zones[i]->getTZID());
#endif
		addZone(zones[i]);
	}
}
			
TimeZones::TimeZones(MetaObject zone, int yr, TimeZones::TZPolicy pol)
{
#ifdef TZ_DEBUG
	printf(IDSTRING"Single zone constructor. Not to be used.\n");
#endif
	setPolicy(pol);
	setYear(yr);
	addZone(&zone);
}

int TimeZones::tzIdQuery(QString id=QString::null)
{
	int *index=tzIdList[id];
	if(index==NULL)
		return -1;
	return *index;
}

int TimeZones::tzNameQuery(QString name=QString::null)
{
	int *index=tzNameList[name];
	if(index==NULL)
		return -1;
	return *index;
}


void TimeZones::setPolicy(TZPolicy pol)
{
	policy=pol;
}

bool TimeZones::addZone(MetaObject *mObj)
{
	VTimeZone vtz(mObj, year);
	return addZone(vtz);
}
bool TimeZones::addZone(VTimeZone tz)
{
	int *index=tzIdList[tz.getTZID()];
	int count=timezoneList.count();
	/*
	 *		If I don't find the timezone yet, then just add it into the list.
	 */
	if(index==NULL)
	{
		timezoneList.append(tz);
		// set the tzIdList
		tzIdList.insert(tz.getTZID(),new int(count));
		// set the tzNamesList
		QStringList tzNames=tz.getTzNames();
		for(int i=0;i<tzNames.count();i++)
			tzNameList.insert(tzNames[i],new int(count));
		return true;
	}
	/*
	 *		I already have it!
	 */
	switch (policy)
	{
		case TimeZones::Ask:
			timer = new QTimer( this );
			connect( timer, SIGNAL(timeout()), this, SLOT(internalAskAnswer()) );
			timer->start( timerValue, TRUE ); // single shot!
			// if is undecided, then loop!
			while(askValue==TimeZones::Undecided);
			// if the user decided to replace the timezone, then "just do it".
			if(askValue==TimeZones::True)
			{
				removeZone(*index);
				addZone(tz);
				return true;
			}
			return false;
		case TimeZones::Keep:
			return false;
		case TimeZones::Overwrite:
			removeZone(*index);
			addZone(tz);
			return true;
		case TimeZones::MostRecent:
			// if "LAST-MODIFIED" is older then just return.
			if(tz.getLastModified()<timezoneList[*index].getLastModified())
				return false;
			// else do a "Replace"
			removeZone(*index);
			addZone(tz);
			return true;
	}
	// if the policy is wrong or something, return false;
	return false;
}

bool TimeZones::removeZone(QString name, bool isTZID)
{
#ifdef TZ_DEBUG
	printf(IDSTRING"removeZone(name): not implemented\n");
#endif
    return false;
}

bool TimeZones::removeZone(int index)
{
#ifdef TZ_DEBUG
	printf(IDSTRING"removeZone(index): not implemented\n");
#endif
    return false;
}



/**
 *			THE SLOTS!
 */
void TimeZones::askAnswer(AskValues response)
{
#ifdef TZ_DEBUG
	printf(IDSTRING"Answer triggered by an ezternal object\n");
#endif
	if(timer) { delete timer; timer=NULL; }
	askValue=response;
	if(askValue==TimeZones::Undecided)
		internalAskAnswer();
}
void TimeZones::internalAskAnswer()
{
#ifdef TZ_DEBUG
	printf(IDSTRING"Internal answer triggered by timer\n");
#endif
	if(timer) { delete timer; timer=NULL; }
	askValue=TimeZones::False;
}




