/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <qstringlist.h>
#include <miscfunctions.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#undef HAS_TOOLBOX_H
#include <toolbox.h>

#ifdef IDSTRING
	#undef IDSTRING
#endif
#define IDSTRING "Toolbox: "

//#define DEBUG_TOOLBOX

Toolbox tb;

QDateTime Toolbox::getDateTime(const QString &datetime, QString &tz)
{
	QDateTime result;
	char c[5];
	int year, month, day, hour, minute, second;
	int offset=0;
	
	if(datetime[0]!='T')
	{
		// then I have a full date
		c[0]=((const char *)datetime)[0]; 
		c[1]=((const char *)datetime)[1]; 
		c[2]=((const char *)datetime)[2]; 
		c[3]=((const char *)datetime)[3]; 
		c[4]=0;
		year=atoi(c);
		c[0]=((const char *)datetime)[4]; c[1]=((const char *)datetime)[5]; c[2]=0;
		month=atoi(c);
		c[0]=((const char *)datetime)[6]; c[1]=((const char *)datetime)[7]; c[2]=0;
		day=atoi(c);
		offset=9;
		result.setDate(QDate(year, month, day));
	}
//	else
//	{
//		result.setDate(QDate(1, 1, 1));
//	}
	c[0]=((const char *)datetime)[0+offset];
	c[1]=((const char *)datetime)[1+offset];
	c[2]=0;
	hour=atoi(c);
	c[0]=((const char *)datetime)[2+offset];
	c[1]=((const char *)datetime)[3+offset]; 
	c[2]=0;
	minute=atoi(c);
	c[0]=((const char *)datetime)[4+offset];
	c[1]=((const char *)datetime)[5+offset]; 
	c[2]=0;
	second=atoi(c);
	result.setTime(QTime(hour, minute, second));
	tz=datetime.right(6+offset);
	return result;
}

QDateTime Toolbox::getDateTime(const QString &str, TimeZone &tz)
{
	QDateTime result;
	QString timezone;
	result=getDateTime(str, timezone);
	// setting up the timezone stuff
	tz=Toolbox::UnknownTimeZone;
	if((timezone[0]=='Z') && (timezone.length()==1))
		tz=Toolbox::ZULUTimeZone;
	// ready to go
#ifdef DEBUG_TOOLBOX
	printf(IDSTRING"Result is: date:\"%s\"\n",
		(const char *)result.date().toString());
	printf(IDSTRING"Result is: time:\"%s\"\n",
		(const char *)result.time().toString());
	printf(IDSTRING"\tyear: %d\n",result.date().year());
#endif
	return result;
}

QString Toolbox::extractNumbers(const QString &str, int pos)
{
	QString result;
	int offset=0;
	while(isdigit(((const char *)str)[pos+offset]))
	{
		result.append(((const char *)str)[pos+offset]);
		offset ++;
	}
	return result;
}

long Toolbox::getDateTimeOffset(const QString &str, IntervalType &offsetType)
{
	long result=0;
	QString temp;
	int offset=0;
	offsetType=Toolbox::DefaultTime;
	if(str[0]=='-')
	{
		offset++;
		offsetType=Toolbox::BeforeTime;
	}
	if(str[0]=='+')
	{
		offset++;
		offsetType=Toolbox::AfterTime;
	}
#ifdef DEBUG_TOOLBOX
	switch(offsetType)
	{
		case DefaultTime:
			printf(IDSTRING"Time is set to be the parent's default offset\n");
			break;
		case BeforeTime:
			printf(IDSTRING"Offset is set to occur before the parent's default\n");
			break;
		case AfterTime:
			printf(IDSTRING"Offset is set to occur after the parent's default\n");
			break;
	}
#endif
	if(str[offset]!='P')
	{
		printf(IDSTRING"Error: Invalid date/time offset : \"%s\". Returning 0\n",
			(const char *)str);
		return result;
	}
	offset ++;
	int days, hours, minutes, seconds;
	days=hours=minutes=seconds=0;
	temp=extractNumbers(str,offset);
	if(!temp.isEmpty()) // then this is the day stuff
	{
		offset +=temp.length();
		if(str[offset]=='D')
		{
#ifdef DEBUG_TOOLBOX
			printf(IDSTRING"will occur after %s days\n",(const char *)temp);
#endif
			days=atoi((const char *)temp);
			result=setDays(days);
			offset ++;
		}
		else
		{
#ifdef DEBUG_TOOLBOX
			printf(IDSTRING"will occur after %s weeks\n",(const char *)temp);
#endif
			days=7*atoi((const char *)temp);
			result=setDays(days);
			return result;
		}
	}
#ifdef DEBUG_TOOLBOX
	else
		printf(IDSTRING"will occur after 0 days\n");
#endif
	if(str[offset]!='T')
	{
		printf(IDSTRING"Error: invalid offset date format.\n");
		return result;
	}
	offset++;
	temp=extractNumbers(str,offset);
#ifdef DEBUG_TOOLBOX
		printf(IDSTRING"will occur after %s ",(const char *)temp);
#endif
	offset+=temp.length();
	// if the item is W then this is the only item!
/*	if(str[offset]=='W')
	{
#ifdef DEBUG_TOOLBOX
			printf("weeks\n");
#endif
		// the event will occur after x weeks 
		days+=7*atoi((const char *)temp);
		result=Toolbox::setDays(days);
		return result;
	}
*/
	//otherwise check if is Hours
	if(str[offset]=='H')
	{
#ifdef DEBUG_TOOLBOX
			printf("hours\n");
#endif
		hours=atoi((const char *)temp);
		result+=Toolbox::setHours(hours);
		offset ++;
		temp=extractNumbers(str,offset);
		offset+=temp.length();
		if(temp.isEmpty()) return result;
#ifdef DEBUG_TOOLBOX
		printf(IDSTRING"will occur after %s ",(const char *)temp);
#endif
	}
	//otherwise check if is Minutes
	if(str[offset]=='M')
	{
#ifdef DEBUG_TOOLBOX
			printf("minutes\n");
#endif
		minutes=atoi((const char *)temp);
		result+=Toolbox::setMinutes(minutes);
		offset ++;
		temp=extractNumbers(str,offset);
		offset+=temp.length();
		if(temp.isEmpty()) return result;
#ifdef DEBUG_TOOLBOX
		printf(IDSTRING"will occur after %s ",(const char *)temp);
#endif
	}
	//otherwise check if is Seconds
	if(str[offset]=='S')
	{
#ifdef DEBUG_TOOLBOX
			printf("seconds\n");
#endif
		seconds=atoi((const char *)temp);
		result+=Toolbox::setSeconds(seconds);
	}
	return result;
}

long Toolbox::getTimeOffset(const QString &str)
{
	bool negative=false;
	unsigned int offset=0;
	if(str[0]=='-') 
	{
		negative=true;
		offset++;
	}
	if(str.length()%2)
	{
		printf(IDSTRING"Invalid time.\n");
		return 0;
	}
	long result=0;
	result+=setHours(str.mid(0+offset,2).toInt());
	result+=setMinutes(str.mid(2+offset,2).toInt());
	result+=setSeconds(str.mid(4+offset,2).toInt());
	if(negative) result=-result;
#ifdef DEBUG_TOOLBOX
	printf(IDSTRING"Returning : %ld\n",result);
#endif
	return result;
}

long Toolbox::setDays(int days) { return days*TOOLBOX_DAY; }

long Toolbox::setHours(int hours) { return hours*TOOLBOX_HOUR; }

long Toolbox::setMinutes(int minutes) { return minutes*TOOLBOX_MINUTE; }

long Toolbox::setSeconds(int seconds) { return seconds; }

int Toolbox::getDays(long seconds)
{
	return seconds/TOOLBOX_DAY;
}

int Toolbox::getHours(long seconds)
{
	return (seconds-(seconds/TOOLBOX_DAY)*TOOLBOX_DAY)/TOOLBOX_HOUR;
}

int Toolbox::getMinutes(long seconds)
{
	return (seconds-(seconds/TOOLBOX_HOUR)*TOOLBOX_HOUR)/TOOLBOX_MINUTE;
}

int Toolbox::getSeconds(long seconds)
{
	return seconds%TOOLBOX_MINUTE;
}

Period Toolbox::parseString(const QString &period)
{
	Period p;
	p.isFinished=false;
	p.length=0;
	QStringList parts=enhancedSplit(period,'/',QStringList());
		// parts[0] will contain the starting date if interval
	Toolbox::TimeZone tz;
	p.start=tb.getDateTime(parts[0],tz);
	if(parts.count()==2)
	{
		if(((const char *)parts[1])[0]=='P')
		{
			// then is an offset
			Toolbox::IntervalType offsetType;
			p.length=tb.getDateTimeOffset(parts[1], offsetType);
#ifdef DEBUG_TOOLBOX
			printf(IDSTRING" Seconds(1): %d <%s>\n",p.length,
				(const char *)parts[1]);
#endif
		}
		else
		{
			QDateTime temp=tb.getDateTime(parts[1],tz);
			p.length=p.start.secsTo(temp);
#ifdef DEBUG_TOOLBOX
			printf(IDSTRING" Seconds(2): %d <%s>\n",p.length,
				(const char *)parts[1]);
#endif
		}
	}
	return p;
}
