/*
 * basemenu.hh
 * Copyright (C) 2000 Frank Hale
 * frankhale@yahoo.com
 * http://sapphire.sourceforge.net/
 *
 * Updated: 1 Nov 2001
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 
#ifndef _BASEMENU_HH_
#define _BASEMENU_HH_

// Parts below borrowed from fspanel.c
static unsigned short cols[] = {
	0xd75c, 0xd75c, 0xd75c,		  /* 0. light gray */
	0xbefb, 0xbaea, 0xbefb,		  /* 1. mid gray */
	0xaefb, 0xaaea, 0xaefb,		  /* 2. dark gray */
	0xefbe, 0xefbe, 0xefbe,		  /* 3. white */
	0x8617, 0x8207, 0x8617,		  /* 4. darkest gray */
	0x0000, 0x0000, 0x0000		  /* 5. black */
	//0x7000, 0x8000, 0x9000
};

#define PALETTE_COUNT (sizeof (cols) / sizeof (cols[0]) / 3)

extern unsigned long palette[PALETTE_COUNT];

#define DEFAULT_FOREGROUND_COLOR 	"black"
#define DEFAULT_BACKGROUND_COLOR	"slategrey"
#define DEFAULT_BORDER_COLOR		"black"
#define DEFAULT_BORDER_SIZE		1
#define DEFAULT_SPACE			3
#define DEFAULT_MARGIN			6
#define DEFAULT_MINIMUM_SIZE		10

class BaseMenu
{
protected:	
	// Contains the menu items of this menu.
	LinkedList<BaseMenuItem> *mi;
	
	Window parent;
	
	Display *dpy;
	Window  root;
	Visual  *visual;
	int	depth;
	unsigned int     screen;
	
	// Menu specific stuff ==========================
	Window item_window;
	int x, y, x_move, y_move;
	unsigned int width,height, total_item_height;
	bool isVisible;
	// ==============================================
	
	XSetWindowAttributes attrib;
	unsigned long create_mask;	

	XColor xforeground_color, xbackground_color, xborder_color;

	Cursor curs;
	GC gc;
	GC select_gc;
	XFontStruct *font;
	XCharStruct overall;
	
	int direction;
	int ascent;
	int descent;
	int counter;
	
	bool bottom_edge;
	bool right_edge;
	
	unsigned int item_width,item_height;
	
	unsigned int xres, yres;
	
	// Used to know which item to paint.
	BaseMenuItem *curr;
	
	// This is for our synthetic enter event and we only want this to happen once.
	// This is set to true once we detect the mouse has entered the item window.
	bool enterOnce;	

public:		
	BaseMenu();
	virtual ~BaseMenu();

	LinkedList<BaseMenuItem> *getMenuItemList() const { return mi; }
	
	int getItemCount() const { return mi->count(); }
	
	bool is_visible() const { return isVisible; }
					
	void setMenuPos(int x, int y);
	void show();
	void show(int x, int y);
	void showSub(BaseMenu *sub, int x, int y);
	void hide(BaseMenu *sub);
	void hideAllVisibleSubmenus();
	
	int getMenuHeight() const { return height; }
	
	void updateMenu();

	virtual void insert(std::string n, BaseMenu *sub);
	virtual void insert(std::string n, std::string exec, int func);
	virtual void insert(std::string n, std::string exec, BaseMenu *sub, int func);
	virtual void insert(BaseMenuItem *item);

	int remove(BaseMenuItem *element);
	void removeAll();

	BaseMenuItem *findMenuItem(int x, int y);

	virtual void handle_button_press_event(XButtonEvent *e);
	virtual void handle_button_release_event(XButtonEvent *e);
	void handle_enter_notify(XCrossingEvent *e);
	void handle_leave_notify(XCrossingEvent *e);
	void handle_expose_event(XExposeEvent *e);
	void handle_motion_notify_event(XMotionEvent *e);

	// The menu item behavoir is defined with these
	// virtual functions in a derived class.
	virtual void handle_button1_press(BaseMenuItem *curr)   { /* Has no default behavior */ }
	virtual void handle_button2_press(BaseMenuItem *curr)   { /* Has no default behavior */ }
	virtual void handle_button3_press(BaseMenuItem *curr)   { /* Has no default behavior */ }
	virtual void handle_button1_release(BaseMenuItem *curr) { /* Has no default behavior */ }
	virtual void handle_button2_release(BaseMenuItem *curr) { /* Has no default behavior */ }
	virtual void handle_button3_release(BaseMenuItem *curr) { /* Has no default behavior */ }

	void execute(std::string s);

	Window getMenuWindow() 	    const { return item_window; }

	virtual void redraw();
	void hide();

private:
	void initializeMenu(Display *display);

	virtual void redraw(BaseMenuItem *m);
		
	void selectMenuItem(int col);
	void getMousePosition(int *x, int *y);
	void testMenuEdgeDetect(BaseMenu *sub);		

	// Not meant to be called directly by subclasses! Used internally.
	void hideSubmenus(); 
	
	void setForeground (int index);
	void draw3DLine(Window win, int x1, int y1, int x2, int y2);
};

#endif
