/* aewm - a minimalist X11 window mananager. vim:noet:sw=4:ts=4
 * Copyright 1998-2001 Decklin Foster <decklin@red-bean.com>
 * This program is free software; see LICENSE for details. */

#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <stdio.h>
#include <stdlib.h>
#include "aeclients.h"
#include "panel.h"

Display *dpy;
Window root;

static void get_gnome_pda(int *left, int *right, int *top, int *bottom)
{
	Atom real_type; int real_format;
	unsigned long items_read, bytes_left;
	int *data;

	if (XGetWindowProperty(dpy, root, gnome_pda, 0L, 4L, False,
			XA_CARDINAL, &real_type, &real_format, &items_read, &bytes_left,
			(unsigned char **) &data) == Success && items_read) {
		*left = data[0];
		*right = data[1];
		*top = data[2];
		*bottom = data[3];
	} else {
		*left = 0;
		*right = 0;
		*top = 0;
		*bottom = 0;
	}
	XFree(data);
}

int main(int argc, char **argv)
{
	int i, opt_verbose = 0, opt_show = 0;
	int left, right, top, bottom;

	dpy = XOpenDisplay(NULL);

	if (!dpy) {
		fprintf(stderr, "can't open display '%s' (is $DISPLAY set properly?)\n",
			getenv("DISPLAY"));
		exit(1);
	}

	root = DefaultRootWindow(dpy);
	gnome_pda = XInternAtom(dpy, "GNOME_PANEL_DESKTOP_AREA", False);

	get_gnome_pda(&left, &right, &top, &bottom);

	for (i = 1; i < argc; i++) {
		if ARG("left", "l", 1)     { left   = atoi(argv[++i]); continue; }
		if ARG("right", "r", 1)    { right  = atoi(argv[++i]); continue; }
		if ARG("top", "t", 1)      { top    = atoi(argv[++i]); continue; }
		if ARG("bottom", "b", 1)   { bottom = atoi(argv[++i]); continue; }
		if ARG("show", "v", 0)     { opt_show    = 1; continue; }
		if ARG("verbose", "vv", 0) { opt_verbose = 1; continue; }
		fprintf(stderr, "usage: set-gnome-pda [--left|-l n] [--right|-r n]\n"
		                "                     [--top|-t n] [--bottom|-b n]\n"
		                "                     [--show|-v] [--verbose|-vv]\n");
		exit(2);
	}

	/* doesn't work unless we call get again. i don't know why. */
	set_gnome_pda(left, right, top, bottom);
	get_gnome_pda(&left, &right, &top, &bottom);

	if (opt_verbose) {
		printf("Left edge:   %3d pixels\n", left);
		printf("Right edge:  %3d pixels\n", right);
		printf("Top edge:    %3d pixels\n", top);
		printf("Bottom edge: %3d pixels\n", bottom);
	} else if (opt_show) {
		printf ("%d %d %d %d\n", left, right, top, bottom);
	}

	return 0;
}
