#
#  $Id: acsite.m4,v 1.5 2002/11/01 14:09:05 kds Exp $
#
#  Affix autoconf macros.
#


AC_DEFUN(AFFIX_ARG_ENABLE, 
	[
	AC_MSG_CHECKING(whether to use $1)
	AC_ARG_ENABLE([$1], AC_HELP_STRING([--enable-$1], [use $1 (default is $2)]), 
	[affix_cv_use_$1=$enableval],
	[AC_CACHE_VAL([affix_cv_use_$1], [affix_cv_use_$1=$2])])
	AC_MSG_RESULT([$affix_cv_use_$1])
	])


# Configure paths for OPENOBEX

AC_DEFUN(AFFIX_PATH_OPENOBEX,
[dnl 
dnl Get the cflags and libraries from the openobex-config script
dnl
AC_ARG_WITH(openobex-prefix,[  --with-openobex-prefix=PFX   Prefix where OPENOBEX is installed (optional)],
            openobex_config_prefix="$withval", openobex_config_prefix="")
AC_ARG_WITH(openobex-exec-prefix,[  --with-openobex-exec-prefix=PFX Exec prefix where OPENOBEX is installed (optional)],
            openobex_config_exec_prefix="$withval", openobex_config_exec_prefix="")

  if test x$openobex_config_exec_prefix != x ; then
     openobex_config_args="$openobex_config_args --exec-prefix=$openobex_config_exec_prefix"
     if test x${OPENOBEX_CONFIG+set} != xset ; then
        OPENOBEX_CONFIG=$openobex_config_exec_prefix/bin/openobex-config
     fi
  fi
  if test x$openobex_config_prefix != x ; then
     openobex_config_args="$openobex_config_args --prefix=$openobex_config_prefix"
     if test x${OPENOBEX_CONFIG+set} != xset ; then
        OPENOBEX_CONFIG=$openobex_config_prefix/bin/openobex-config
     fi
  fi

  AC_PATH_PROG(OPENOBEX_CONFIG, openobex-config, no)
  if test "$OPENOBEX_CONFIG" != "no" ; then
	openobex_config_version=`$OPENOBEX_CONFIG $openobex_config_args --version`
	min_openobex_version=ifelse([$1], ,0.9.8,$1)
	AC_MSG_CHECKING(for openobex - version >= $min_openobex_version)

	OPENOBEX_CFLAGS=`$OPENOBEX_CONFIG $openobex_config_args --cflags`
	OPENOBEX_LIBS=`$OPENOBEX_CONFIG $openobex_config_args --libs`

	openobex_config_major_version=`$OPENOBEX_CONFIG $openobex_config_args --version | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
	openobex_config_minor_version=`$OPENOBEX_CONFIG $openobex_config_args --version | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
	openobex_config_micro_version=`$OPENOBEX_CONFIG $openobex_config_args --version | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

	openobex_req_major_version=`echo $min_openobex_version | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
	openobex_req_minor_version=`echo $min_openobex_version | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
	openobex_req_micro_version=`echo $min_openobex_version | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

	if test $openobex_req_major_version -le $openobex_config_major_version ; then
		if test $openobex_req_major_version -eq $openobex_config_major_version ; then
			if test $openobex_req_minor_version -le $openobex_config_minor_version ; then
				if test $openobex_req_minor_version -eq $openobex_config_minor_version ; then
					if test $openobex_req_micro_version -le $openobex_config_micro_version ; then
						openobex_config_version_ok="yes"
					fi
				else
					openobex_config_version_ok="yes"
				fi
			fi
		else
			openobex_config_version_ok="yes"
		fi
	fi

	if test "$openobex_config_version_ok" != "yes" ; then
		AC_MSG_ERROR(Installed openobex library too old ($openobex_config_version))
	fi
	openobex_version_code=$((($openobex_config_major_version << 16) + ($openobex_config_minor_version << 8) + $openobex_config_micro_version))

     AC_MSG_RESULT(yes ($openobex_config_version))
     ifelse([$2], , :, [$2])     
  else
     AC_MSG_RESULT(no)
     if test "$OPENOBEX_CONFIG" = "no" ; then
       echo "*** The openobex-config script installed by OPENOBEX could not be found"
       echo "*** If OPENOBEX was installed in PREFIX, make sure PREFIX/bin is in"
       echo "*** your path, or set the OPENOBEX_CONFIG environment variable to the"
       echo "*** full path to openobex-config."
     fi
     OPENOBEX_CFLAGS=""
     OPENOBEX_LIBS=""
     ifelse([$3], , :, [$3])
  fi

  AC_SUBST(OPENOBEX_CFLAGS)
  AC_SUBST(OPENOBEX_LIBS)
])


