/**********************************************************************
 * log.h                                                     March 2001
 * Horms                                             horms@vergenet.net
 *
 * aggregate
 * CIDR network aggregation and filtering
 * Copyright (C) 2001  Horms
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 *
 **********************************************************************/


#ifndef SYSLOG_BERT
#define SYSLOG_BERT

#include <vanessa_logger.h>
#include <syslog.h>
#include <string.h>
#include <errno.h>

extern vanessa_logger_t *aggregate_vl;

#define AGGREGATE_LOG(priority, fmt, args...) \
  vanessa_logger_log(aggregate_vl, priority, fmt, ## args);

#define AGGREGATE_INFO(s) AGGREGATE_LOG(LOG_INFO, s);

#define AGGREGATE_DEBUG(s) AGGREGATE_LOG(LOG_DEBUG, s);

#define AGGREGATE_DEBUG_ERRNO(s, e) \
  AGGREGATE_LOG(LOG_DEBUG, "%s: %e", s, strerror(e));

#endif
