#ifndef _INDIVIDUAL_H
#define _INDIVIDUAL_H

#include "mudobject.h"
#include "flags.h"
#include "wearflags.h"
#include "location.h"

#define DEATHFLAG_BLOW      0
#define DEATHFLAG_SPECIAL   1
#define DEATHFLAG_SLAY      2

#define ATTRIB_HEALTH       0
#define ATTRIB_WIMPY        1
#define ATTRIB_STRENGTH     2
#define ATTRIB_DEXTERITY    3
#define ATTRIB_INTEL        4
#define ATTRIB_CONSTITUTION 5
#define ATTRIB_MAGIC        6
#define ATTRIB_ENDURANCE    7
#define ATTRIB_MAXMAGIC     8
#define ATTRIB_MAXENDUR     9
#define ATTRIB_WISDOM       10
#define ATTRIB_CHARISMA     11
#define ATTRIB_SEX          12

#define VIS_VISIBLE         0
#define VIS_GAME            1
#define VIS_INCOG           2
#define VIS_ADMIN           3

#define SEX_MALE    0
#define SEX_FEMALE  1
#define SEX_NEUTER  2

#ifdef INDIVIDUAL_C
char *vis_table[] = {"Visible", "GameInvis", "Incognito", "AdminInvis", NULL};
#else
extern char *vis_table[];
#endif

class Moveable;
class Wearable;
class Weapon;
class Player;
class Merger;

enum playerhand { Left, Right, Both };

struct worn_item {
   Wearable  *the_obj;
   worn_item *next_worn;
};

/* used to store what this individual has learned */
struct rank_list {
   Strings      rank_name;
   int          the_type;
   int          the_rank;
   int          the_exp_prob;  // Doubles as experience for players, or probability
                               // of using for mobiles
   rank_list    *next_rank;
};

class Individual : public MudObject
{
public:
   Individual();
   virtual ~Individual();

   int tell_ind(Individual *target, char *the_string);
   int move_merger(Individual *target, Merger **the_merger, int num_of);

   int         wield_moveable(Moveable *the_item);
   int         unwield_moveable(playerhand the_hand);
   Moveable    *get_wielded(playerhand the_hand);
   Flags       *get_indflags();

   int         is_male();
   int         is_female();
   int         is_neuter();
   int         get_sex();
   char        *get_sex_possessive_str();
   char        *get_sex_str();
   void        set_sex(int inSex);

   int        add_rank(char *the_name, int type, int the_rank, 
                                                          int the_exp);
   int        add_rank_list(char *the_list);
   int        remove_rank(char *the_name);
   int        find_ability(char *the_name);
   int        find_rank(char *the_name);
   int        get_rank_number(char *the_name);
   int        get_rank_exp_prob(char *the_name);
   int        set_rank_number(char *the_name, int new_num);
   int        set_rank_exp_prob(char *the_name, int new_num);
   void       delete_ranks();
   int        write_ranks(FILE *the_file);
   int        read_ranks(FILE *the_file);
   rank_list  *get_ranks();
   int        display_ranks(Builder *the_builder);
   char       *get_rankname_by_num(int sequence);

   int        get_vislvl();
   char       *get_vislvl_str();
   void       set_vislvl(int in_vislvl);
   int        is_visible();
   int        is_vis_game();
   int        is_vis_incog();
   int        is_vis_admin();
   virtual bool can_see_ind(Individual *the_ind) = 0;

   int        wear_item(Wearable *the_item);
   int        remove_item(Wearable *the_item);
   int        is_worn(Wearable *the_item);
   int        display_top_worn(Player *the_player);
   int        display_all_worn();
   int        has_lit(void);
   int        get_strength();
   int        get_dexterity();
   void       set_strength(int the_value);
   void       set_dexterity(int the_value);
   int        get_health();
   void       set_health(int the_value);
   int        get_maxhealth();
   int        get_constitution();
   void       set_constitution(int the_value);
   int        get_intel();
   void       set_intel(int the_value);
   int        get_wisdom();
   void       set_wisdom(int the_value);
   int        get_charisma();
   void       set_charisma(int the_value);
   int        get_max_magic();
   void       set_max_magic(int the_num);
   int        get_max_endurance();
   void       set_max_endurance(int the_num);
   int        get_magic();
   void       set_magic(int the_num);
   int        get_endurance();
   void       set_endurance(int the_num);
   Location   *get_loc();
   Location   *get_loc(int override_checks);
   char       *get_loc_name();
   virtual int set_location(MudObject *new_loc);
   int        remove_from_loc();
   int        request_fight(Individual *the_target);
   int        start_fight(Individual *the_target);
   void       switch_focus(Individual *the_target);
   void       clr_target();
   int        take_a_swing();
   int        death(int attack_flag, char *name /*, int corpse */);
   int        death(int attack_flag, Individual *the_attacker /*, int corpse */);
   int        death(int attack_flag, Individual *the_attacker, 
                                                 char *name /*, int corpse */);
   int        take_blow(int the_damage, int body_part);
   int        try_step_away(void);
   //   int        do_damage(int the_damage, int body_part);
   int        stop_fighting();
   int        get_wimpy();
   void       set_wimpy(int the_num); 
   int        drop_all();
   int        drop_unworn();
   int        swap_worn(Individual *the_ind);
   char       *get_bare_weapon();
   void       set_bare_weapon(char *the_name);
   int        copy_individual_attrib(Individual *copy_from);
   void       display_health(Player *the_player);
   int        is_asleep();
   int        is_sitting();
   int        game_get_obj(MudObject *the_obj, MudObject *from_obj,
                                               int num_of, int is_held);
   int        reset_curr_loc(void);
   int        clr_curr_loc(void);

   virtual void write_object(FILE *the_file, int build_format);
   virtual char *get_brief();
   int     get_mem_size_ind();

   void reset_individual( void );
   virtual int send_plr(char *new_str, ...);
   int move_dir(char *dir, int flee);
   virtual int is_busy();
   virtual int is_alive();


   /***************************************************************
    ** Combat functions
    ***************************************************************/

   virtual int attack(Individual *target);
   Individual *get_target();
   int use_weapon(Individual *target);
   Weapon *get_rand_weapon(playerhand *the_hand);
   int get_accuracy(Individual *the_wielder, Moveable **the_wielded, 
		    int attack);
   int select_body_part(Moveable **the_wielded, int *acc_attack);
   int check_for_death(int deathflag, Individual *attacker);
   int check_for_flee();
  

protected:
   Flags    *indflags;

private:

   int strength;
   int dexterity;
   int health;
   int constitution;
   int intelligence;
   int wisdom;
   int charisma;

   int vislvl;         // The individual's visibility level.
   int sex;

   int max_magic;
   int magic;
   int max_endurance;
   int endurance;

   int wimpy;

   Strings  bare_weapon;

   Moveable    *left_hand;   /* used to wield or hold a shield or weapon */
   Moveable    *right_hand;  /* used to wield or hold a shield or weapon */ 

   worn_item   *worn_on[WEARFLAG_FEET+1]; /* stack of worn items on body
                                             parts */
   Location    *cur_loc;
   Individual  *target;
   rank_list   *player_ranks;
};

#endif

