/***************************************************************************
 *   Copyright (C) 2004 by Teemu Rytilahti                                 *
 *   tpr@d5k.net                                                           *
 *                                                                         *
 *   Licensed under GPL.                                                   *
 ***************************************************************************/

#ifndef PLUGINBASE_H
#define PLUGINBASE_H

class FeedDetectorEntry;
class KHTMLPart;
class QString;
class QStringList;

namespace Akregator
{

class PluginBase
{
    public:
        PluginBase();
        ~PluginBase();
    
    public:
        /**
        * Tells you if aKregator is running.
        * @return true when aKregator is running
         */
        bool akregatorRunning();
        /**
         * Adds feed to aKregator via DCOP.
         */
        void addFeedsViaDCOP(const QStringList& urls);
        /**
         * Adds feed to aKregator via command line.
         */
        void addFeedViaCmdLine(QString url);
        QString fixRelativeURL(const QString &s, const KURL &baseurl);
};

}
#endif
