from threading import Thread
from gettext import gettext as _
import gtk
import time
import os

class CountThread(Thread):
	def __init__(self, Al, cmd, msg):
		Thread.__init__(self)
		self.setDaemon(True)

		self.msg = msg
		self.cmd = cmd



		if Al[35]:				# If there is no timeout, do this
			self.CountMsg = gtk.MessageDialog(None, gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT, gtk.MESSAGE_QUESTION, gtk.BUTTONS_OK_CANCEL, _("Confirmation equired"))
			self.CountMsg.format_secondary_text(_("Alarm Clock will perform the following action:\n\n%s\n\nin %i seconds. Click \"Cancel\" to cancel the action."))
			self.CountMsg.show()


		else:					# If there is a timeout, do this
			self.CountMsg = gtk.MessageDialog(None, gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT, gtk.MESSAGE_QUESTION, gtk.BUTTONS_OK_CANCEL, _("Confirmation required"))
			self.Text = _("Alarm clock will perform the following action:\n\n%s\n\nClick \"Cancel\" to cancel the action.") % (self.msg)
			self.CountMsg.format_secondary_text(self.Text)
			self.CountMsg.show()



		self.CountMsg.connect("destroy", self.Destroy)
		self.CountMsg.connect("response", self.Response)
		self.Al = Al
		self.counter = Al[36]
		self.WidExist = True
	



	def run(self):
		while self.Al[35] and self.WidExist:
			gtk.gdk.threads_enter()
			self.CountMsg.format_secondary_text(_("Alarm Clock will perform the following action:\n\n%s\n\nin %i seconds. Click \"Cancel\" to cancel the action.") % (self.msg, self.counter))	
	
			self.counter = self.counter - 1	
			gtk.gdk.threads_leave()
			time.sleep(1)
			if self.counter == 0:
				os.system(self.cmd)
				self.CountMsg.destroy()
				self.WidExist = False
				return

	def Destroy(self,obj):
		self.WidExist = False

	def Response(self,obj,response_id):
		self.WidExist = False
		obj.destroy()
		if response_id == gtk.RESPONSE_OK:
			os.system(self.cmd)
			return
		return

