//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef BACKEND_MANIPULATIONS_MOSAIC_H
#define BACKEND_MANIPULATIONS_MOSAIC_H

#include "manipulationOptions.h"
#include <qsize.h>

//--------------------
//forward declarations
//--------------------
class QImage;
class QString;
class QStringList;
class ManipulationOptions;

//====================================================
//Declare mosaic options type
class MosaicOptions : public ManipulationOptions
{
public:
  MosaicOptions(QStringList files, QSize tileSize, StatusWidget* status); 
  QStringList getFileList();
  QSize getTileSize();

private:
  QStringList files;
  QSize tileSize; 
};
//====================================================

//Apply mosaic effect
QImage* mosaicEffect( QString filename, MosaicOptions* options );

#endif //BACKEND_MANIPULATIONS_MOSAIC_H
