//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef CONFIGURATION_LOADINGSAVINGWIDGET_H
#define CONFIGURATION_LOADINGSAVINGWIDGET_H

#include <qdialog.h>

//forward declarations
class QGridLayout;
class QLabel;
class QCheckBox;
class QVGroupBox;
class QLineEdit;
class QPushButton;
class QFrame;
class QComboBox;
class QSlider;
class Configuration;

//=====================================
/*! \brief Loading/Saving Settings
 */
//=====================================

//======================
class LoadingSavingWidget : public QWidget
{
Q_OBJECT
//----------------------
public:
  LoadingSavingWidget( Configuration* config, QWidget *parent=0, const char* name=0);
  static void setDefaults(Configuration* config);
  void loadSettings();
  void saveSettings();
//----------------------
private slots:
  void browse();
//----------------------
private:
  ///Backend config object pointer
  Configuration* config;

  QGridLayout* mainGrid;
  //-------
  //Main Category and separation line
  QLabel* categoryLabel;
  QFrame* horizontalLine;
  //-------
  //Default new album theme
  QFrame* defaultToThisThemeFrame;
  QGridLayout* defaultToThisThemeGrid;
  QLabel* defaultToThisThemeOnNew;
  QComboBox* defaultToThisTheme;
  //----------------------
  ///Temporary Image directory
  QFrame* tempImageDirectoryFrame;
  QGridLayout* tempImageDirectoryGrid;
  QLabel* tempImageDirectory;
  QLineEdit* tempImageDirectoryVal;
  QPushButton* browseButton;
  //----------------------
  ///Check for photo modifications on load
  QCheckBox* checkPhotoMods;
  //----------------------

};
//======================

#endif //CONFIGURATION_LOADINGSAVINGWIDGET_H
