// ---------------------------------------------------------------------------
// - Axlopts.hpp                                                             -
// - aleph cross librarian - options class definitions                       -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2001 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef ALEPH_AXLOPTS_HPP
#define ALEPH_AXLOPTS_HPP

#ifndef  ALEPH_STRVEC_HPP
#include "Strvec.hpp"
#endif

namespace aleph {

  /// The Axlopts class is the class used by the aleph cross librarian to 
  /// store user options. The instance is simply created with the standard 
  /// main program arguments.
  /// @author amaury darsch

  class Axlopts {
  private:
    /// the paths list
    Strvec d_path;
    /// the librarian name
    String d_lname;
    /// the create flag
    bool d_cflg;
    /// the extract flag
    bool d_xflg;
    /// the info flag
    bool d_info;
    /// the list flag
    bool d_list;

  public:
    /// create a new option class from the main arguments
    /// @param argc the number of arguments
    /// @param argv the argument array
    Axlopts (int argc, char** argv);

    /// @return the string vector of paths
    const Strvec& getpath (void) const {
      return d_path;
    }

    /// @return the librarian file name
    String getlname (void) const {
      return d_lname;
    }

    /// @return the create option
    bool getcflg (void) const {
      return d_cflg;
    }

    /// @return the extract option
    bool getxflg (void) const {
      return d_xflg;
    }

    /// @return the option info
    bool getinfo (void) const {
      return d_info;
    }

    /// @return the option list
    bool getlist (void) const {
      return d_list;
    }

  private:
    // make the copy constructor private
    Axlopts (const Axlopts&);
    // make the assignment operator private
    Axlopts& operator = (const Axlopts&);
  };
}

#endif
