# This Alicq module used to save positions of newly opened wnidows and open
# then with saved geometry on creation

# Author: Ihar Viarheichyk <iverg@mail.ru>

package require Tk
variable file geometry

# Save geometry information if it was changed
proc SaveWin {win} {
	variable file
	variable cache
	set gm [wm geometry $win]
	if {![info exists cache($win)] || $cache($win)!=$gm} {
		set win [string range $win 1 end]
		if {$win==""} {
			set win [winfo class .]
			Save $file "\\\*${win}\\\.geometry:"\
				"*$win.geometry: $gm"
		} else {
			option add *$win.geometry $gm 
			after idle [list Save $file "\\\*${win}\\\.geometry:"\
				"*$win.geometry: $gm"]
		}		
	}
	if {[info exists cache($win)]} { unset cache($win) }
}

proc SaveProportion {win} {
	variable cache
	variable file
	set height [winfo height $win]
	if {![info exists cache($win)] || $cache($win)!=$height} {
		set win [string range $win 1 end]
		after idle [list Save $file "\\\*${win}\\\.height:" "*${win}.height: $height"]
	}
	if {[info exists cache($win)]} { unset cache($win) }
}

proc CacheProportion {win} {
	variable cache
	set cache($win) [winfo height $win]
}

bind SaveGeometry <Destroy> [nc SaveWin %W]

# Save proporting between incoming and outgoing messages panes
bind SaveProportions <Map> [nc CacheProportion %W]
bind SaveProportions <Destroy> [nc SaveProportion %W]

# Read geometry information from file, if exists. If file has wrong format,
# it is overwriten with suffix .bad
if [file exists $file] {
	if {[catch { option readfile $file startupFile }]} {
		file rename -force $file ${file}.bad
	}
}

bindtags . [concat [bindtags .]	SaveGeometry]
