
# Version is not changed in runtime, thus can be pre-calculated
set os "$::tcl_platform(os) $::tcl_platform(osVersion)"
variable version [xmpp::tag {jabber:iq:version query} [::xmpp::tag name Alicq][::xmpp::tag version [package present alicq]][xmpp::tag os $os]]

# Send our version responce if required
handler xmpp:/iq(get)/jabber:iq:version:query Version {obj args} {
	variable version
	set ${obj}(result) $version
}

# Handle incoming version tags
handler xmpp:/iq(result)/jabber:iq:version:query/* client {obj name _ val} {
	if {$val==""} return
	set ${obj}(client:[lindex $name end]) $val
}

# Set client and os properties for contact uid '''1
handler Iq:result:version set-version {obj id from} {
	upvar 0 ${obj} context
	if {[info exists context(client:version)]} {
		append context(client:name) " " $context(client:version)
		unset context(client:version)
	}
	set ref [ref Contact:xmpp:[lindex [split $from /] 0]]
	array set $ref [array get context]
	set ${ref}(Status) [set ${ref}(Status)]
}

# Request version information when client changes presence to available '''1
handler xmpp:/presence AskVersion {obj name attrs val} {
	array set opt $attrs
	set ref [ref Contact:xmpp:[lindex [split $opt(from) /] 0]]
	if {[info exists opt(type)] && $opt(type)=="unavailable"} {
		# Client is offline
		array unset ${ref} client:*
	} elseif {![info exists ${ref}(client:provided)]} {
		[namespace tail $obj] send [xmpp::tag iq type get id version\
			to $opt(from) [xmpp::tag {jabber:iq:version query}]]
		set ${ref}(client:provided) 1
	}
}
