/* $Id: wmmain.h,v 1.23 2000/11/11 23:41:54 komatsu Exp $ */

#ifndef __WM_MAIN_H__
#define __WM_MAIN_H__

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <glib.h>
#include "wmrc.h"
#include "wmgroup.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define WM_XWINDOW(widget) (((GdkWindowPrivate *)((GdkWindow *)(GTK_WIDGET(widget)->window)))->xwindow)
#define WM_XPARENT(widget) (((GdkWindowPrivate*)((GdkWindowPrivate*)widget->window)->parent)->xwindow)
#define EVENT_XWINDOW(event) (((GdkWindowPrivate *)event->window)->xwindow)

void wm_main_restart(gchar *path);
void wm_main_exit(gint return_value);
void wm_message(const gchar* format, ...);

gint32 wm_get_current_desktop(void);
gint32 wm_get_workspace_count(void);

extern GdkAtom wm_atom_wm_state;
extern GdkAtom wm_atom_wm_hints;
extern GdkAtom wm_atom_wm_client_leader;
extern GdkAtom wm_atom_wm_change_state;

extern int ShapeEventBase;
extern int ShapeErrorBase;

extern WmRc      *wmrc;
extern gchar     *rc_error;
extern GtkWidget *root;
extern GtkWidget *dummy_window;
extern GtkWidget *launcher;

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __WM_MAIN_H__ */
