/* $Id: wmmenuitem.c,v 1.4 2000/11/11 23:41:54 komatsu Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include "wmmain.h"
#include "wmclient.h"
#include "wmmenuitem.h"
#include "wmmisc.h"
#include <X11/Xlib.h>

GtkWidget *wm_menu_item_new_with_wmlabel(WmLabelList *list)
{
    GtkWidget *item;
    GtkWidget *label;

    item  = gtk_menu_item_new();
    label = wm_label_new(list);
    gtk_container_add(GTK_CONTAINER(item), label);
    gtk_widget_show(label);

    return item;
}

/***********************************************************************
 * Button1,2,3 Ƚ̤Τ, wmaction ǽǽˤ뤿Ѱդ,
 * ACTIVATE ٥Ȥȶ¸ǤƤʤ, 졼ͭ
 * Ǥʤ. ϤΥåȤȤ⤷ʤ, 
 * ʲϤäα.
 ***********************************************************************/

static gint wm_menu_item_press(GtkWidget *widget, GdkEventButton *event, 
			    gpointer data);
static gint wm_menu_item_release(GtkWidget *widget, GdkEventButton *event, 
			      gpointer data);
static void wm_menu_item_class_init(WmMenuItemClass *class);
static void wm_menu_item_init(WmMenuItem *wm_menu_item);

guint wm_menu_item_get_type(void)
{
    static guint wm_menu_item_type = 0;

    if (!wm_menu_item_type) {
	GtkTypeInfo wm_menu_item_info =
	{
	    "WmMenuItem",
	    sizeof (WmMenuItem),
	    sizeof (WmMenuItemClass),
	    (GtkClassInitFunc) wm_menu_item_class_init,
	    (GtkObjectInitFunc) wm_menu_item_init,
	    (GtkArgSetFunc) NULL,
	    (GtkArgGetFunc) NULL
	};

	wm_menu_item_type = gtk_type_unique(gtk_menu_item_get_type(), 
					 &wm_menu_item_info);
    }
    return wm_menu_item_type;
}

enum {
    WM_MENU_ITEM_PRESS1,
    WM_MENU_ITEM_PRESS2,
    WM_MENU_ITEM_PRESS3,
    WM_MENU_ITEM_RELEASE1,
    WM_MENU_ITEM_RELEASE2,
    WM_MENU_ITEM_RELEASE3,
    LAST_SIGNAL
};

static gint wm_menu_item_signals[LAST_SIGNAL] = { 0 };

static void wm_menu_item_class_init(WmMenuItemClass *class)
{
    GtkObjectClass *object_class;

    object_class = (GtkObjectClass*) class;

    wm_menu_item_signals[WM_MENU_ITEM_PRESS1] = 
	gtk_signal_new("press1", GTK_RUN_FIRST, object_class->type, 
		       GTK_SIGNAL_OFFSET(WmMenuItemClass, press1),
		       gtk_marshal_NONE__POINTER,
		       GTK_TYPE_NONE, 1,
		       GTK_TYPE_GDK_EVENT);
    wm_menu_item_signals[WM_MENU_ITEM_PRESS2] = 
	gtk_signal_new("press2", GTK_RUN_FIRST, object_class->type, 
		       GTK_SIGNAL_OFFSET(WmMenuItemClass, press2),
		       gtk_marshal_NONE__POINTER,
		       GTK_TYPE_NONE, 1,
		       GTK_TYPE_GDK_EVENT);
    wm_menu_item_signals[WM_MENU_ITEM_PRESS3] = 
	gtk_signal_new("press3", GTK_RUN_FIRST, object_class->type, 
		       GTK_SIGNAL_OFFSET(WmMenuItemClass, press3),
		       gtk_marshal_NONE__POINTER,
		       GTK_TYPE_NONE, 1,
		       GTK_TYPE_GDK_EVENT);

    wm_menu_item_signals[WM_MENU_ITEM_RELEASE1] = 
	gtk_signal_new("release1", GTK_RUN_FIRST, object_class->type, 
		       GTK_SIGNAL_OFFSET(WmMenuItemClass, release1),
		       gtk_marshal_NONE__POINTER, GTK_TYPE_NONE, 1,
		       GTK_TYPE_GDK_EVENT);
    wm_menu_item_signals[WM_MENU_ITEM_RELEASE2] = 
	gtk_signal_new("release2", GTK_RUN_FIRST, object_class->type, 
		       GTK_SIGNAL_OFFSET(WmMenuItemClass, release2),
		       gtk_marshal_NONE__POINTER, GTK_TYPE_NONE, 1,
		       GTK_TYPE_GDK_EVENT);
    wm_menu_item_signals[WM_MENU_ITEM_RELEASE3] = 
	gtk_signal_new("release3", GTK_RUN_FIRST, object_class->type, 
		       GTK_SIGNAL_OFFSET(WmMenuItemClass, release3),
		       gtk_marshal_NONE__POINTER, GTK_TYPE_NONE, 1,
		       GTK_TYPE_GDK_EVENT);

    gtk_object_class_add_signals(object_class, wm_menu_item_signals, LAST_SIGNAL);

    class->press1   = NULL;
    class->press2   = NULL;
    class->press3   = NULL;
    class->release1 = NULL;
    class->release2 = NULL;
    class->release3 = NULL;
}

static void wm_menu_item_init(WmMenuItem *wm_menu_item)
{
    GtkWidget *menu_item;
         
    menu_item = gtk_menu_item_new();
    gtk_widget_show(menu_item);
}

GtkWidget* wm_menu_item_new(void)
{
    GtkWidget *menu_item;
    menu_item = GTK_WIDGET(gtk_type_new(wm_menu_item_get_type()));

    wm_menu_item_connect_event(menu_item, NULL);

    return menu_item;
}

GtkWidget* wm_menu_item_new_with_label(gchar *label)
{
    GtkWidget *menu_item;
    GtkWidget *accel_label;

    menu_item = wm_menu_item_new();
    accel_label = gtk_accel_label_new(label);
    gtk_misc_set_alignment(GTK_MISC(accel_label), 0.0, 0.5);

    gtk_container_add(GTK_CONTAINER(menu_item), accel_label);
    gtk_accel_label_set_accel_widget(GTK_ACCEL_LABEL(accel_label), menu_item);
    gtk_widget_show(accel_label);

    return menu_item;
}

void wm_menu_item_connect_event(GtkWidget *menu_item, gpointer data)
{
    gtk_signal_connect(GTK_OBJECT(menu_item), "button_press_event",
		       GTK_SIGNAL_FUNC(wm_menu_item_press), data);
    gtk_signal_connect(GTK_OBJECT(menu_item), "button_release_event",
		       GTK_SIGNAL_FUNC(wm_menu_item_release), data);
}

static gint wm_menu_item_press(GtkWidget *widget, GdkEventButton *event, 
			       gpointer data)
{
    guint signal;

    wm_message("WmMenuItem: press\n");

    signal = ((event->button == Button1) ? WM_MENU_ITEM_PRESS1 :
	      (event->button == Button2) ? WM_MENU_ITEM_PRESS2 :
	      (event->button == Button3) ? WM_MENU_ITEM_PRESS3 : LAST_SIGNAL);

    if(signal != LAST_SIGNAL) {
	gtk_signal_emit(GTK_OBJECT(widget), 
			wm_menu_item_signals[signal], event);
    }
    return FALSE;
}


static gint wm_menu_item_release(GtkWidget *widget, GdkEventButton *event, 
				 gpointer data)
{
    guint signal;

    signal = ((event->button == Button1) ? WM_MENU_ITEM_RELEASE1 :
	      (event->button == Button2) ? WM_MENU_ITEM_RELEASE2 :
	      (event->button == Button3) ? WM_MENU_ITEM_RELEASE3 :LAST_SIGNAL);

    if(signal != LAST_SIGNAL) {
	gtk_signal_emit(GTK_OBJECT(widget), 
			wm_menu_item_signals[signal], event);
    }
    return FALSE;
}

