/* $Id: wmmisc.c,v 1.25 2000/11/11 23:41:54 komatsu Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdlib.h> /* malloc */
#ifdef HAVE_UNISTD_H
#include <unistd.h> /* _exit, execl, fork  */
#endif /* HAVE_UNISTD_H */
#include "wmmisc.h"
#include "wmmain.h"
#include "wmaction.h"
#include "wmmenuitem.h"
#include "wmmenu.h"

static void wm_signal_free(GtkWidget *widget, gpointer data);
static void wm_signal_destroy(GtkWidget *widget, gpointer data);
static GDataForeachFunc 
wm_launcher_new_foreach(GQuark id, gpointer data, gpointer user_data);

struct _WmSignalInfo {
    GtkObject *object;
    gint id;
};

typedef struct _WmSignalInfo WmSignalInfo;

static GtkWidget *menu_dummy;

static void wm_signal_destroy(GtkWidget *widget, gpointer data)
{
    wm_message("WmMisc: wm_signal_destroy\n");
    gtk_signal_disconnect(GTK_OBJECT(((WmSignalInfo *)data)->object),
			  ((WmSignalInfo *)data)->id);
    g_free(data);
}

static void wm_signal_free(GtkWidget *widget, gpointer data)
{
    wm_message("WmMisc: wm_signal_free\n");
    g_free(data);
}

/* func_data Ƥ Widget õ줿Ȥ˥ʥ³ */
void wm_signal_connect_safety(GtkObject *object, const gchar *name,
			      GtkSignalFunc func, gpointer func_data)
{
    if(GTK_IS_WIDGET(func_data)) {
	WmSignalInfo *info;
	wm_message("WmMisc: signal_connect_safety\n");
	info = (WmSignalInfo *)g_malloc(sizeof(WmSignalInfo));
	info->id = gtk_signal_connect(object, name, func, func_data);
	info->object = object;
	gtk_signal_connect(GTK_OBJECT(func_data), "destroy",
			   GTK_SIGNAL_FUNC(wm_signal_destroy),
			   (gpointer)info);
    } else {
	wm_message("WmMisc: signal_connect_normally\n");
	gtk_signal_connect(object, name, func, func_data);
    }
}

/* object õ줿Ȥ func_data  (ƵŪˤϲʤ) */
void wm_signal_connect_with_struct(GtkObject *object, const gchar *name,
				   GtkSignalFunc func, gpointer tmp_struct)
{
    wm_message("WmMisc: signal_connect_with_struct\n");
    gtk_signal_connect(object, name, func, tmp_struct);
    gtk_signal_connect(object, "destroy",
		       GTK_SIGNAL_FUNC(wm_signal_free), tmp_struct);
}

#if 1
void wm_signal_connect_safety_with_struct(GtkObject *object, const gchar *name,
					  GtkSignalFunc func,
					  gpointer tmp_struct)
{
    WmSignalInfo *info;
    wm_message("WmMisc: signal_connect_safety_with_struct\n");
    info = (WmSignalInfo *)g_malloc(sizeof(WmSignalInfo));
    info->id = gtk_signal_connect(object, name, func, tmp_struct);
    info->object = object;
    gtk_signal_connect(GTK_OBJECT(((WmWidgetStruct *)tmp_struct)->widget),
		       "destroy",
		       GTK_SIGNAL_FUNC(wm_signal_destroy),
		       (gpointer)info);
    gtk_signal_connect(GTK_OBJECT(((WmWidgetStruct *)tmp_struct)->widget),
		       "destroy",
		       GTK_SIGNAL_FUNC(wm_signal_free), tmp_struct);
}
#endif


void wm_event_add(GtkWidget *widget, GdkEventMask mask)
{
    gdk_window_set_events(widget->window, 
			  mask | gdk_window_get_events(widget->window));
}

void wm_event_del(GtkWidget *widget, GdkEventMask mask)
{
    gdk_window_set_events(widget->window, 
			  ~mask & gdk_window_get_events(widget->window));
}

void wm_exec(gchar *command)
{
    pid_t pid;

    pid = fork();
    if(pid == -1) {
	wm_message("WmRoot: fork failed.\n");
	return;
    } else if(pid == 0) {
	wm_message("WmRoot: child process\n");
	if(execl(command, command, NULL) == -1) {
	    wm_message("WmRoot: execl failed.\n");
	    _exit(1);
	}
    }
}

GtkWidget* wm_launcher_new(void)
{
    GtkWidget *launcher, *item_dummy;

    wm_message("WmMisc: wm_launcher_new\n");

    if (wmrc) {
	menu_dummy = gtk_menu_new();
	item_dummy = gtk_menu_item_new_with_label("<< Loop Error! >>");
	gtk_menu_append(GTK_MENU(menu_dummy), item_dummy);
	gtk_widget_show(item_dummy);
	
	launcher = wm_launcher_get("menu_main");
	if (launcher) {
	    return launcher;
	}
    }
    /* Error!! launcher is not found. */
    wm_message("WmMisc: wmrc or menu_main is NULL\n");
    return wm_launcher_new_default();
}


GDataForeachFunc
wm_launcher_new_foreach(GQuark id, gpointer data, gpointer user_data) {
    wm_message("WmMisc: wm_launcher_new_foreach\n");

    gtk_widget_show(wm_launcher_new_from_rc(data));
    return NULL; /* NULL ֤Ȥ Warning 򤱰ʾΰ̣Ϥʤ */
}

    
GtkWidget* wm_launcher_get(const gchar *id)
{
    WmRcMenu *rcmenu;
    wm_message("WmMisc: wm_launcher_get [%s]\n", id); 

    rcmenu = g_datalist_get_data(&(wmrc->menus), id);
    if (rcmenu) {
	if (!(rcmenu->widget)) {
	    rcmenu->widget = menu_dummy;
	    rcmenu->widget = wm_launcher_new_from_rc(rcmenu);
	}
	return rcmenu->widget;
    } else {
	return NULL;
    }
}

GtkWidget* wm_launcher_new_from_rc(WmRcMenu *rc)
{
    GList *list;
    WmRcMenuItem *rc_item;
    GtkWidget *menu;
    GtkWidget *submenu;
    GtkWidget *item;
    GtkWidget *label;

    wm_message("WmMisc: wm_launcher_new_from_rc\n");
/*     menu = rc->widget; */
    menu = gtk_menu_new();

    for (list = rc->item; list; list = list->next) {
	rc_item = list->data;
/* 	wm_message("WmMisc: wm_launcher_new_from_rc title = %s\n",  */
/* 		   rc_item->title); */
	wm_message("WmMisc: wm_launcher_new_from_rc\n");

	switch (rc_item->type) {
	case RC_MENU_EXEC:
	    item  = wm_menu_item_new_with_wmlabel(rc_item->title);
	    gtk_signal_connect_object(GTK_OBJECT(item), "activate",
				      GTK_SIGNAL_FUNC(wm_exec), 
				      (gpointer)g_strdup(rc_item->command));
	    break;

	case RC_MENU_HR:
	    item = gtk_menu_item_new();
	    break;

	case RC_MENU_SYSTEM:
	    item  = wm_menu_item_new_with_wmlabel(rc_item->title);
	    gtk_signal_connect(GTK_OBJECT(item), "activate",
			       wm_rc_system_get_func(rc_item->command), NULL);
	    break;

	case RC_MENU_RESTART:
	    item  = wm_menu_item_new_with_wmlabel(rc_item->title);
	    gtk_signal_connect_object(GTK_OBJECT(item), "activate",
				      GTK_SIGNAL_FUNC(wm_main_restart),
				      (gpointer)g_strdup(rc_item->command));
	    break;

	case RC_MENU_EXIT:
	    item  = wm_menu_item_new_with_wmlabel(rc_item->title);
	    gtk_signal_connect_object(GTK_OBJECT(item), "activate",
				      GTK_SIGNAL_FUNC(wm_main_exit), NULL);
	    break;

	case RC_MENU_MENU:
	    item  = wm_menu_item_new_with_wmlabel(rc_item->title);
	    submenu = wm_launcher_get(rc_item->command);
	    gtk_menu_item_set_submenu(GTK_MENU_ITEM(item), submenu);
	    break;

	default:
	    item = gtk_menu_item_new();
	    break;
	    
	}
	gtk_menu_append(GTK_MENU(menu), item);
	gtk_widget_show(item);
    }
    return menu;
}

GtkWidget* wm_launcher_new_default(void)
{
    GtkWidget *menu;
    GtkWidget *item;

    menu = gtk_menu_new();

    item = gtk_menu_item_new_with_label("Terminal");
    gtk_signal_connect_object(GTK_OBJECT(item), "activate",
			      GTK_SIGNAL_FUNC(wm_exec), (gpointer)XTERM);
    gtk_menu_append(GTK_MENU(menu), item);
    gtk_widget_show(item);

    item = gtk_menu_item_new(); /* ѥ졼 */
    gtk_menu_append(GTK_MENU(menu), item);
    gtk_widget_show(item);

    item = gtk_menu_item_new_with_label("New Group ...");
    gtk_signal_connect(GTK_OBJECT(item), "activate",
		       GTK_SIGNAL_FUNC(wm_group_dialog), NULL);
    gtk_menu_append(GTK_MENU(menu), item);
    gtk_widget_show(item);

    item = gtk_menu_item_new(); /* ѥ졼 */
    gtk_menu_append(GTK_MENU(menu), item);
    gtk_widget_show(item);

    item = gtk_menu_item_new_with_label("Restart");
    gtk_signal_connect_object(GTK_OBJECT(item), "activate",
			      GTK_SIGNAL_FUNC(wm_main_restart), NULL);
    gtk_menu_append(GTK_MENU(menu), item);
    gtk_widget_show(item);

    item = gtk_menu_item_new_with_label("TWM");
    gtk_signal_connect_object(GTK_OBJECT(item), "activate",
			      GTK_SIGNAL_FUNC(wm_main_restart),
			      (gpointer)"twm");
    gtk_menu_append(GTK_MENU(menu), item);
    gtk_widget_show(item);

    item = gtk_menu_item_new(); /* ѥ졼 */
    gtk_menu_append(GTK_MENU(menu), item);
    gtk_widget_show(item);

    item = gtk_menu_item_new_with_label("Exit");
    gtk_signal_connect_object(GTK_OBJECT(item), "activate",
			      GTK_SIGNAL_FUNC(wm_main_exit), NULL);
    gtk_menu_append(GTK_MENU(menu), item);
    gtk_widget_show(item);

    return menu;
}


typedef void (*WmSignal_NONE__INT_INT_INT) (GtkObject * object,
					    gint arg1,
					    gint arg2,
					    gint arg3,
					    gpointer user_data);

void wm_marshal_NONE__INT_INT_INT(GtkObject *object,  GtkSignalFunc func,
				  gpointer func_data, GtkArg *args)
{
    WmSignal_NONE__INT_INT_INT rfunc;
    rfunc = (WmSignal_NONE__INT_INT_INT) func;
    (*rfunc) (object,
	      GTK_VALUE_INT (args[0]),
	      GTK_VALUE_INT (args[1]),
	      GTK_VALUE_INT (args[2]),
	      func_data);
}

/* ---------------------------------------------------------------------- */

void wm_alert(const char* title, const char* message)
{
    GtkWidget *hbox, *scrollbar, *frame, *dialog;
    GtkWidget *button_close, *text;
    GdkFont   *font_fixed;

    dialog = gtk_dialog_new();
    frame  = gtk_frame_new(title ? title : "");

    hbox = gtk_hbox_new(FALSE, 0);

    font_fixed = gdk_font_load("fixed");

    text = gtk_text_new(NULL, NULL);
    gtk_widget_set_usize(text, 500, 150);
    gtk_text_insert(text, font_fixed, NULL, NULL, message, -1);
    gtk_box_pack_start(GTK_BOX(hbox), text, FALSE, FALSE, 0);

    scrollbar = gtk_vscrollbar_new (GTK_TEXT(text)->vadj);
    gtk_box_pack_start(GTK_BOX(hbox), scrollbar, FALSE, FALSE, 0);

    gtk_container_border_width(GTK_CONTAINER(GTK_DIALOG(dialog)), 5);
    gtk_container_add(GTK_CONTAINER(frame), hbox);

    button_close = gtk_button_new_with_label("close");
    GTK_WIDGET_SET_FLAGS(button_close, GTK_CAN_DEFAULT);
    gtk_signal_connect_object(GTK_OBJECT(button_close), "clicked",
			      gtk_widget_destroy, GTK_OBJECT(dialog));

    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		       frame, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		       button_close, TRUE, TRUE, 0);

    gtk_widget_show(text);
    gtk_widget_show(scrollbar);
    gtk_widget_show(hbox);
    gtk_widget_show(frame);
    gtk_widget_show(button_close);
    gtk_window_position(GTK_WINDOW(dialog), GTK_WIN_POS_MOUSE);
    gtk_widget_show(dialog);

/*     gdk_keyboard_grab(dialog->window, TRUE, CurrentTime); */
/*     gtk_grab_add(dialog); */
/*     gtk_signal_connect_object(GTK_OBJECT(dialog), "destroy", */
/* 			      gtk_grab_remove, GTK_OBJECT(dialog)); */
}
