<?php
/* vim:set tabstop=8 softtabstop=8 shiftwidth=8 noexpandtab: */
/**
 * Show Edit Catalog
 *
 *
 * LICENSE: GNU General Public License, version 2 (GPLv2)
 * Copyright (c) 2001 - 2011 Ampache.org All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License v2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * @package	Ampache
 * @copyright	2001 - 2011 Ampache.org
 * @license	http://opensource.org/licenses/gpl-2.0 GPLv2
 * @link	http://www.ampache.org/
 */

?>
<?php /* HINT: Catalog Name */ show_box_top(sprintf(T_('Settings for %s') , $catalog->name . ' (' . $catalog->path . ')'), 'box box_edit_catalog'); ?>
<form method="post" action="<?php echo Config::get('web_path'); ?>/admin/catalog.php" enctype="multipart/form-data">
<table cellspacing="0" cellpadding="0">
<tr>
	<td><?php echo T_('Name'); ?>:</td>
	<td><input size="60" type="text" name="name" value="<?php echo scrub_out($catalog->name); ?>"></input></td>
	<td style="vertical-align:top; font-family: monospace;" rowspan="5">
		<strong><?php echo T_('Auto-inserted Fields'); ?>:</strong><br />
		%A = <?php echo T_('album name'); ?><br />
		%a = <?php echo T_('artist name'); ?><br />
		%c = <?php echo T_('id3 comment'); ?><br />
		%T = <?php echo T_('track number (padded with leading 0)'); ?><br />
		%t = <?php echo T_('song title'); ?><br />
		%y = <?php echo T_('year'); ?><br />
		%o = <?php echo T_('other'); ?><br />
	</td>
</tr>
<tr>
	<td><?php echo T_('Catalog Type'); ?></td>
	<td><?php echo scrub_out(ucfirst($catalog->catalog_type)); ?></td>
</tr>
<tr>
        <td><?php echo T_('Remote Catalog Username'); ?>: </td>
        <td><input size="30" type="text" name="remote_username" value="<?php echo scrub_out($catalog->remote_username); ?>" /><span class="error">*<?php echo T_('Required for Remote Catalogs'); ?></span></td>
</tr>
<tr>
        <td><?php echo T_('Remote Catalog Password'); ?>: </td>
        <td><input size="30" type="password" name="remote_password" value="" /><span class="error">*<?php echo T_('Required for Remote Catalogs'); ?></span></td>
</tr>
<tr>
	<td><?php echo T_('Filename pattern'); ?>:</td>
	<td>
		<input size="60" type="text" name="rename_pattern" value="<?php echo scrub_out($catalog->rename_pattern); ?>" />
	</td>
</tr>
<tr>
	<td>
		<?php echo T_('Folder Pattern'); ?>:<br /><?php echo T_('(no leading or ending \'/\')'); ?>
	</td>
	<td>
		<input size="60" type="text" name="sort_pattern" value="<?php echo scrub_out($catalog->sort_pattern);?>" />
	</td>
</tr>
</table>
<div class="formValidation">
	<input type="hidden" name="catalog_id" value="<?php echo scrub_out($catalog->id); ?>" />
	<input type="hidden" name="action" value="update_catalog_settings" />
	<input class="button" type="submit" value="<?php echo T_('Save Catalog Settings'); ?>" />
</div>
</form>
<?php show_box_bottom(); ?>
