# 4 What is the right-libertarian position on private property?

Right libertarians are not interested in eliminating capitalist private
property and thus the authority, oppression and exploitation which goes with
it. It is true that they call for an end to the state, but this is not because
they are concerned about workers being exploited or oppressed but because they
don't want the state to impede capitalists' "freedom" to exploit and oppress
workers even more than is the case now!

They make an idol of private property and claim to defend absolute,
"unrestricted" property rights (i.e. that property owners can do anything they
like with their property, as long as it does not damage the property of
others. In particular, taxation and theft are among the greatest evils
possible as they involve coercion against "justly held" property). They agree
with John Adams that _"[t]he moment that idea is admitted into society that
property is not as sacred as the Laws of God, and that there is not a force of
law and public justice to protect it, anarchy and tyranny commence. Property
must be sacred or liberty cannot exist."_

But in their celebration of property as the source of liberty they ignore the
fact that private property is a source of "tyranny" in itself (see sections
[B.1](secB1.html) and [B.4](secB4.html), for example -- and please note that
anarchists only object to private property, **not** individual possession, see
section [B.3.1](secB3.html#secb31)). However, as much anarchists may disagree
about other matters, they are united in condemning private property. Thus
Proudhon argued that property was _"theft"_ and _"despotism"_ while Stirner
indicated the religious and statist nature of private property and its impact
on individual liberty when he wrote :

> _"Property in the civic sense means **sacred** property, such that I must
**respect** your property... Be it ever so little, if one only has somewhat of
his own - to wit, a **respected** property: The more such owners... the more
'free people and good patriots' has the State. _

>

> _"Political liberalism, like everything religious, counts on **respect,**
humaneness, the virtues of love. . . . For in practice people respect nothing,
and everyday the small possessions are bought up again by greater proprietors,
and the 'free people' change into day labourers."_ [**The Ego and Its Own**,
p. 248]

Thus "anarcho"-capitalists reject totally one of the common (and so defining)
features of all anarchist traditions -- the opposition to capitalist property.
From Individualist Anarchists like Tucker to Communist-Anarchists like
Bookchin, anarchists have been opposed to what Godwin termed _"accumulated
property."_ This was because it was in _"direct contradiction"_ to property in
the form of _"the produce of his [the worker's] own industry"_ and so it
allows _"one man. . . [to] dispos[e] of the produce of another man's
industry."_ [**The Anarchist Reader**, pp. 129-131] Thus, for anarchists,
capitalist property is a source exploitation and domination, **not** freedom
(it undermines the freedom associated with possession by created relations of
domination between owner and employee).

Hardly surprising then the fact that, according to Murray Bookchin, Murray
Rothbard _"attacked me [Bookchin] as an anarchist with vigour because, as he
put it, I am opposed to private property."_ [**The Raven**, no. 29, p. 343]

We will discuss Rothbard's "homesteading" justification of property in the
[next section](append134.html#secf41). However, we will note here one aspect
of right-libertarian defence of "unrestricted" property rights, namely that it
easily generates evil side effects such as hierarchy and starvation. As famine
expert Amartya Sen notes:

> _"Take a theory of entitlements based on a set of rights of 'ownership,
transfer and rectification.' In this system a set of holdings of different
people are judged to be just (or unjust) by looking at past history, and not
by checking the consequences of that set of holdings. But what if the
consequences are recognisably terrible? . . .[R]efer[ing] to some empirical
findings in a work on famines . . . evidence [is presented] to indicate that
in many large famines in the recent past, in which millions of people have
died, there was no over-all decline in food availability at all, and the
famines occurred precisely because of shifts in entitlement resulting from
exercises of rights that are perfectly legitimate. . . . [Can] famines . . .
occur with a system of rights of the kind morally defended in various ethical
theories, including Nozick's. I believe the answer is straightforwardly yes,
since for many people the only resource that they legitimately possess, viz.
their labour-power, may well turn out to be unsaleable in the market, giving
the person no command over food . . . [i]f results such as starvations and
famines were to occur, would the distribution of holdings still be morally
acceptable despite their disastrous consequences? There is something deeply
implausible in the affirmative answer."_ [**Resources, Values and
Development**, pp. 311-2]

Thus "unrestricted" property rights can have seriously bad consequences and so
the existence of "justly held" property need not imply a just or free society
-- far from it. The inequalities property can generate can have a serious on
individual freedom (see section [3.1](append133.html#secf31)). Indeed, Murray
Rothbard argued that the state was evil not because it restricted individual
freedom but because the resources it claimed to own were not "justly"
acquired. Thus right-libertarian theory judges property **not** on its impact
on current freedom but by looking at past history. This has the interesting
side effect of allowing its supporters to look at capitalist and statist
hierarchies, acknowledge their similar negative effects on the liberty of
those subjected to them but argue that one is legitimate and the other is not
simply because of their history! As if this changed the domination and
unfreedom that both inflict on people living today (see section
[2.3](append132.html#secf23) for further discussion and sections
[2.8](append132.html#secf28) and [4.2](append134.html#secf42) for other
examples of "justly acquired" property producing terrible consequences).

The defence of capitalist property does have one interesting side effect,
namely the need arises to defend inequality and the authoritarian
relationships inequality creates. In order to protect the private property
needed by capitalists in order to continue exploiting the working class,
"anarcho"-capitalists propose private security forces rather than state
security forces (police and military) -- a proposal that is equivalent to
bringing back the state under another name.

Due to (capitalist) private property, wage labour would still exist under
"anarcho"-capitalism (it is capitalism after all). This means that "defensive"
force, a state, is required to "defend" exploitation, oppression, hierarchy
and authority from those who suffer them. Inequality makes a mockery of free
agreement and "consent" (see section [3.1](append133.html#secf31)). As Peter
Kropotkin pointed out long ago:

> _"When a workman sells his labour to an employer . . . it is a mockery to
call that a free contract. Modern economists may call it free, but the father
of political economy -- Adam Smith -- was never guilty of such a
misrepresentation. As long as three-quarters of humanity are compelled to
enter into agreements of that description, force is, of course, necessary,
both to enforce the supposed agreements and to maintain such a state of
things. Force -- and a good deal of force -- is necessary to prevent the
labourers from taking possession of what they consider unjustly appropriated
by the few. . . . The Spencerian party [proto-right-libertarians] perfectly
well understand that; and while they advocate no force for changing the
existing conditions, they advocate still more force than is now used for
maintaining them. As to Anarchy, it is obviously as incompatible with
plutocracy as with any other kind of -cracy."_ [**Anarchism and Anarchist
Communism**, pp. 52-53]

Because of this need to defend privilege and power, "anarcho"-capitalism is
best called "private-state" capitalism. This will be discussed in more detail
in section [6](append136.html).

By advocating private property, right libertarians contradict many of their
other claims. For example, they say that they support the right of individuals
to travel where they like. They make this claim because they assume that only
the state limits free travel. But this is a false assumption. Owners must
agree to let you on their land or property (_"people only have the right to
move to those properties and lands where the owners desire to rent or sell to
them."_ [Murray Rothbard, **The Ethics of Liberty**, p. 119]. There is no
"freedom of travel" onto private property (including private roads). Therefore
immigration may be just as hard under "anarcho"-capitalism as it is under
statism (after all, the state, like the property owner, only lets people in
whom it wants to let in). People will still have to get another property owner
to agree to let them in before they can travel -- exactly as now (and, of
course, they also have to get the owners of the road to let them in as well).
Private property, as can be seen from this simple example, is the state writ
small.

One last point, this ignoring of ("politically incorrect") economic and other
views of dead political thinkers and activists while claiming them as
"libertarians" seems to be commonplace in right-Libertarian circles. For
example, Aristotle (beloved by Ayn Rand) _"thought that only living things
could bear fruit. Money, not a living thing, was by its nature barren, and any
attempt to make it bear fruit (**tokos**, in Greek, the same word used for
interest) was a crime against nature."_ [Marcello de Cecco, quoted by Doug
Henwood, **Wall Street**, p. 41] Such opposition to interest hardly fits well
into capitalism, and so either goes unmentioned or gets classed as an "error"
(although we could ask why Aristotle is in error while Rand is not).
Similarly, individualist anarchist opposition to capitalist property and rent,
interest and profits is ignored or dismissed as "bad economics" without
realising that these ideas played a key role in their politics and in ensuring
that an anarchy would not see freedom corrupted by inequality. To ignore such
an important concept in a person's ideas is to distort the remainder into
something it is not.

## 4.1 What is wrong with a "homesteading" theory of property?

So how do "anarcho"-capitalists justify property? Looking at Murray Rothbard,
we find that he proposes a _"homesteading theory of property"_. In this theory
it is argued that property comes from occupancy and mixing labour with natural
resources (which are assumed to be unowned). Thus the world is transformed
into private property, for _"title to an unowned resource (such as land) comes
properly only from the expenditure of labour to transform that resource into
use."_ [**The Ethics of Liberty**, p. 63]

Rothbard paints a conceptual history of individuals and families forging a
home in the wilderness by the sweat of their labour (its tempting to rename
his theory the _"immaculate conception of property"_ as his conceptual theory
is somewhat at odds with actual historical fact).

Sadly for Murray Rothbard, his "homesteading" theory was refuted by Proudhon
in **What is Property?** in 1840 (along with many other justifications of
property). Proudhon rightly argues that _"if the liberty of man is sacred, it
is equally sacred in all individuals; that, if it needs property for its
objective action, that is, for its life, the appropriation of material is
equally necessary for all . . . Does it not follow that if one individual
cannot prevent another . . . from appropriating an amount of material equal to
his own, no more can he prevent individuals to come."_ And if all the
available resources are appropriated, and the owner _"draws boundaries, fences
himself in . . . Here, then, is a piece of land upon which, henceforth, no one
has a right to step, save the proprietor and his friends . . . Let [this]. . .
multiply, and soon the people . . . will have nowhere to rest, no place to
shelter, no ground to till. They will die at the proprietor's door, on the
edge of that property which was their birthright."_ [**What is Property?**,
pp. 84-85, p. 118]

As Rothbard himself noted in respect to the aftermath of slavery (see section
[2.1](append132.html#secf21)), not having access to the means of life places
one the position of unjust dependency on those who do. Rothbard's theory fails
because for _"[w]e who belong to the proletaire class, property excommunicates
us!"_ [P-J Proudhon, **Op. Cit.**, p. 105] and so the vast majority of the
population experience property as theft and despotism rather than as a source
of liberty and empowerment (which possession gives). Thus, Rothbard's account
fails to take into account the Lockean Proviso (see section
[B.3.4](secB3.html#secb34)) and so, for all its intuitive appeal, ends up
justifying capitalist and landlord domination (see [next
section](append134.html#secf42) on why the Lockean Proviso is important).

It also seems strange that while (correctly) attacking social contract
theories of the state as invalid (because _"no past generation can bind later
generations"_ [**Op. Cit.**, p. 145]) he fails to see he is doing **exactly
that** with his support of private property (similarly, Ayn Rand argued that
_"[a]ny alleged 'right' of one man, which necessitates the violation of the
right of another, is not and cannot be a right"_ [**Capitalism: The Unknown
Ideal**, p. 325] but obviously appropriating land does violate the rights of
others to walk, use or appropriate that land). Due to his support for
appropriation and inheritance, he is clearly ensuring that future generations
are **not** born as free as the first settlers were (after all, they cannot
appropriate any land, it is all taken!). If future generations cannot be bound
by past ones, this applies equally to resources and property rights. Something
anarchists have long realised -- there is no defensible reason why those who
first acquired property should control its use by future generations.

However, if we take Rothbard's theory at face value we find numerous problems
with it. If title to unowned resources comes via the _"expenditure of labour"_
on it, how can rivers, lakes and the oceans be appropriated? The banks of the
rivers can be transformed, but can the river itself? How can you mix your
labour with water? "Anarcho"-capitalists usually blame pollution on the fact
that rivers, oceans, and so forth are unowned, but how can an individual
"transform" water by their labour? Also, does fencing in land mean you have
"mixed labour" with it? If so then transnational corporations can pay workers
to fence in vast tracks of virgin land (such as rainforest) and so come to
"own" it. Rothbard argues that this is not the case (he expresses opposition
to _"arbitrary claims"_). He notes that it is **not** the case that _"the
first discoverer . . . could properly lay claim to [a piece of land] . . .
[by] laying out a boundary for the area."_ He thinks that _"their claim would
still be no more than the boundary **itself**, and not to any of the land
within, for only the boundary will have been transformed and used by men"_
[**Op. Cit.**, p. 50f]

However, if the boundary **is** private property and the owner refuses others
permission to cross it, then the enclosed land is inaccessible to others! If
an "enterprising" right-libertarian builds a fence around the only oasis in a
desert and refuses permission to cross it to travellers unless they pay his
price (which is everything they own) then the person **has** appropriated the
oasis without "transforming" it by his labour. The travellers have the choice
of paying the price or dying (and the oasis owner is well within his rights
letting them die). Given Rothbard's comments, it is probable that he will
claim that such a boundary is null and void as it allows "arbitrary" claims --
although this position is not at all clear. After all, the fence builder
**has** transformed the boundary and "unrestricted" property rights is what
right-libertarianism is all about.

And, of course, Rothbard ignores the fact of economic power -- a transnational
corporation can "transform" far more virgin resources in a day than a family
could in a year. Transnational's "mixing their labour" with the land does not
spring into mind reading Rothbard's account of property growth, but in the
real world that is what will happen.

If we take the question of wilderness (a topic close to many eco-anarchists'
and deep ecologists' hearts) we run into similar problems. Rothbard states
clearly that _"libertarian theory must invalidate [any] claim to ownership"_
of land that has _"never been transformed from its natural state"_ (he
presents an example of an owner who has left a piece of his _"legally owned"_
land untouched). If another person appears who **does** transform the land, it
becomes _"justly owned by another"_ and the original owner cannot stop her
(and should the original owner _"use violence to prevent another settler from
entering this never-used land and transforming it into use"_ they also become
a _"criminal aggressor"_). Rothbard also stresses that he is **not** saying
that land must continually be in use to be valid property [**Op. Cit.**, pp.
63-64] (after all, that would justify landless workers seizing the land from
landowners during a depression and working it themselves).

Now, where does that leave wilderness? In response to ecologists who oppose
the destruction of the rainforest, "anarcho"-capitalists suggest that they put
their money where their mouth is and **buy** rainforest land. In this way, it
is claimed, rainforest will be protected (see section [B.5](secB5.html) for
why such arguments are nonsense). As ecologists desire the rainforest
**because it is wilderness** they are unlikely to "transform" it by human
labour (its precisely that they want to stop). From Rothbard's arguments it is
fair to ask whether logging companies have a right to "transform" the virgin
wilderness owned by ecologists, after all it meets Rothbard's criteria (it is
still wilderness). Perhaps it will be claimed that fencing off land
"transforms" it (hardly what you imagine "mixing labour" with to mean, but
nevermind) -- but that allows large companies and rich individuals to hire
workers to fence in vast tracks of land (and recreate the land monopoly by a
"libertarian" route). But as we noted above, fencing off land does not seem to
imply that it becomes property in Rothbard's theory. And, of course, fencing
in areas of rainforest disrupts the local eco-system -- animals cannot freely
travel, for example -- which, again, is what ecologists desire to stop. Would
Rothbard accept a piece of paper as "transforming" land? We doubt it (after
all, in his example the wilderness owner **did** legally own it) -- and so
most ecologists will have a hard time in "anarcho"-capitalism (wilderness is
just not an option).

As an aside, we must note that Rothbard fails to realise -- and this comes
from his worship of the market and his "Austrian economics" -- is that people
value many things which do not appear on the market. He claims that wilderness
is _"valueless unused natural objects"_ (for it people valued them, they would
use -- i.e. appropriate -- them). But unused things may be of **considerable**
value to people, wilderness being a classic example. And if something
**cannot** be transformed into private property, does that mean people do not
value it? For example, people value community, stress free working
environments, meaningful work -- if the market cannot provide these, does that
mean they do not value them? Of course not (see Juliet Schor's **The
Overworked American** on how working people's desire for shorter working hours
was not transformed into options on the market).

Moreover, Rothbard's "homesteading" theory actually violates his support for
unrestricted property rights. What if a property owner **wants** part of her
land to remain wilderness? Their desires are violated by the "homesteading"
theory (unless, of course, fencing things off equals "transforming" them,
which it apparently does not). How can companies provide wilderness holidays
to people if they have no right to stop settlers (including large companies)
"homesteading" that wilderness? And, of course, where does Rothbard's theory
leave hunter-gather or nomad societies. They **use** the resources of the
wilderness, but they do not "transform" them (in this case you cannot easily
tell if virgin land is empty or being used as a resource). If a troop of
nomads find its traditionally used, but natural, oasis appropriated by a
homesteader what are they to do? If they ignore the homesteaders claims he can
call upon his "defence" firm to stop them -- and then, in true Rothbardian
fashion, the homesteader can refuse to supply water to them unless they hand
over all their possessions (see section [4.2](append134.html#secf42) on this).
And if the history of the United States (which is obviously the model for
Rothbard's theory) is anything to go by, such people will become "criminal
aggressors" and removed from the picture.

Which is another problem with Rothbard's account. It is completely ahistoric
(and so, as we noted above, is more like an _"immaculate conception of
property"_). He has transported "capitalist man" into the dawn of time and
constructed a history of property based upon what he is trying to justify (not
surprising, as he does this with his "Natural Law" theory too - see [section
7](append137.html)). What **is** interesting to note, though, is that the
**actual** experience of life on the US frontier (the historic example
Rothbard seems to want to claim) was far from the individualistic framework he
builds upon it and (ironically enough) it was destroyed by the development of
capitalism.

As Murray Bookchin notes, _"the independence that the New England yeomanry
enjoyed was itself a function of the co-operative social base from which it
emerged. To barter home-grown goods and objects, to share tools and
implements, to engage in common labour during harvesting time in a system of
mutual aid, indeed, to help new-comers in barn-raising, corn-husking, log-
rolling, and the like, was the indispensable cement that bound scattered
farmsteads into a united community."_ [**The Third Revolution**, vol. 1, p.
233] Bookchin quotes David P. Szatmary (author of a book on Shay' Rebellion)
stating that it was a society based upon _"co-operative, community orientated
interchanges"_ and not a _"basically competitive society."_ [**Ibid.**]

Into this non-capitalist society came capitalist elements. Market forces and
economic power soon resulted in the transformation of this society. Merchants
asked for payment in specie which (and along with taxes) soon resulted in
indebtedness and the dispossession of the homesteaders from their land and
goods. In response Shay's rebellion started, a rebellion which was an
important factor in the centralisation of state power in America to ensure
that popular input and control over government were marginalised and that the
wealthy elite and their property rights were protected against the many (see
Bookchin, **Op. Cit.**, for details). Thus the homestead system was
undermined, essentially, by the need to pay for services in specie (as
demanded by merchants).

So while Rothbard's theory as a certain appeal (reinforced by watching too
many Westerns, we imagine) it fails to justify the "unrestricted" property
rights theory (and the theory of freedom Rothbard derives from it). All it
does is to end up justifying capitalist and landlord domination (which is
probably what it was intended to do).

## 4.2 Why is the "Lockean Proviso" important?

Robert Nozick, in his work **Anarchy, State, and Utopia** presented a case for
private property rights that was based on what he termed the _"Lockean
Proviso"_ \-- namely that common (or unowned) land and resources could be
appropriated by individuals as long as the position of others is not worsen by
so doing. However, if we **do** take this Proviso seriously private property
rights cannot be defined (see section [B.3.4](secB3.html#secb34) for details).
Thus Nozick's arguments in favour of property rights fail.

Some right-libertarians, particularly those associated with the Austrian
school of economics argue that we must reject the Lockean Proviso (probably
due to the fact it can be used to undermine the case for absolute property
rights). Their argument goes as follows: if an individual appropriates and
uses a previously unused resource, it is because it has value to him/her, as
an individual, to engage in such action. The individual has stolen nothing
because it was previously unowned and we cannot know if other people are
better or worse off, all we know is that, for whatever reason, they did not
appropriate the resource (_"If latecomers are worse off, well then that is
their proper assumption of risk in this free and uncertain world. There is no
longer a vast frontier in the United States, and there is no point crying over
the fact."_ [Murray Rothbard, **The Ethics of Liberty**, p. 240]).

Hence the appropriation of resources is an essentially individualistic,
asocial act -- the requirements of others are either irrelevant or unknown.
However, such an argument fails to take into account **why** the Lockean
Proviso has such an appeal. When we do this we see that rejecting it leads to
massive injustice, even slavery.

However, let us start with a defence of rejecting the Proviso from a leading
Austrian economist:

> _"Consider . . . the case . . . of the unheld sole water hole in the desert
(which **everyone** in a group of travellers knows about), which one of the
travellers, by racing ahead of the others, succeeds in appropriating . . .
[This] clearly and unjustly violates the Lockean proviso. . . For use,
however, this view is by no means the only one possible. We notice that the
energetic traveller who appropriated all the water was not doing anything
which (always ignoring, of course, prohibitions resting on the Lockean proviso
itself) the other travellers were not equally free to do. The other
travellers, too, could have raced ahead . . . [they] did **not** bother to
race for the water . . . It does not seem obvious that these other travellers
can claim that they were **hurt** by an action which they could themselves
have easily taken"_ [Israel M. Kirzner, _"Entrepreneurship, Entitlement, and
Economic Justice"_, pp. 385-413, in **Reading Nozick**, p. 406]

Murray Rothbard, we should note, takes a similar position in a similar
example, arguing that _"the owner [of the sole oasis] is scarcely being
'coercive'; in fact he is supplying a vital service, and should have the right
to refuse a sale or charge whatever the customers will pay. The situation may
be unfortunate for the customers, as are many situations in life."_ [**The
Ethics of Liberty**, p. 221] (Rothbard, we should note, is relying to the
right-libertarian von Hayek who -- to his credit -- does maintain that this is
a coercive situation; but as others, including other right-libertarians, point
out, he has to change his definition of coercion/freedom to do so -- see
Stephan L. Newman's **Liberalism at Wit's End**, pp. 130-134 for an excellent
summary of this debate).

Now, we could be tempted just to rant about the evils of the right libertarian
mind-frame but we will try to present a clam analysis of this position. Now,
what Kirzner (and Rothbard et al) fails to note is that without the water the
other travellers will die in a matter of days. The monopolist has the power of
life and death over his fellow travellers. Perhaps he hates one of them and so
raced ahead to ensure their death. Perhaps he just recognised the vast power
that his appropriation would give him and so, correctly, sees that the other
travellers would give up all their possessions and property to him in return
for enough water to survive.

Either way, its clear that perhaps the other travellers did not _"race ahead"_
because they were ethical people -- they would not desire to inflict such
tyranny on others because they would not like it inflicted upon them.

Thus we can answer Kirzner's question -- _"What . . . is so obviously
acceptable about the Lockean proviso. . . ?"_ [**Ibid.**]

It is the means by which human actions are held accountable to social
standards and ethics. It is the means by which the greediest, most evil and
debased humans are stopped from dragging the rest of humanity down to their
level (via a "race to the bottom") and inflicting untold tyranny and
domination on their fellow humans. An ideology that could consider the
oppression which could result from such an appropriation as "supplying a vital
service" and any act to remove this tyranny as "coercion" is obviously a very
sick ideology. And we may note that the right-libertarian position on this
example is a good illustration of the dangers of deductive logic from
assumptions (see section [1.3](append131.html#secf13) for more on this right-
libertarian methodology) -- after all W. Duncan Reekie, in his introduction to
Austrian Economics, states that _"[t]o be intellectually consistent one must
concede his absolute right to the oasis."_ [**Markets, Entrepreneurs and
Liberty**, p. 181] To place ideology before people is to ensure humanity is
placed on a Procrustean bed.

Which brings us to another point. Often right-libertarians say that anarchists
and other socialists are "lazy" or "do not want to work". You could interpret
Kirzner's example as saying that the other travellers are "lazy" for not
rushing ahead and appropriating the oasis. But this is false. For under
capitalism you can only get rich by exploiting the labour of others via wage
slavery or, within a company, get better pay by taking "positions of
responsibility" (i.e. management positions). If you have an ethical objection
to treating others as objects ("means to an end") then these options are
unavailable to you. Thus anarchists and other socialists are not "lazy"
because they are not rich -- they just have no desire to get rich off the
labour and liberty of others (as expressed in their opposition to private
property and the relations of domination it creates). In other words,
Anarchism is not the "politics of envy"; it is the politics of liberty and the
desire to treat others as "ends in themselves".

Rothbard is aware of what is involved in accepting the Lockean Proviso --
namely the existence of private property (_"Locke's proviso may lead to the
outlawry of **all** private property of land, since one can always say that
the reduction of available land leaves everyone else . . . worse off"_, **The
Ethics of Liberty**, p. 240 -- see section [B.3.4](secB3.html#secb34) for a
discussion on why the Proviso **does** imply the end of capitalist property
rights). Which is why he, and other right-libertarians, reject it. Its simple.
Either you reject the Proviso and embrace capitalist property rights (and so
allow one class of people to be dispossessed and another empowered at their
expense) or you reject private property in favour of possession and liberty.
Anarchists, obviously, favour the latter option.

As an aside, we should point out that (following Stirner) the would-be
monopolist is doing nothing wrong (as such) in attempting to monopolise the
oasis. He is, after all, following his self-interest. However, what is
objectionable is the right-libertarian attempt to turn thus act into a "right"
which must be respected by the other travellers. Simply put, if the other
travellers gang up and dispose of this would be tyrant then they are right to
do so -- to argue that this is a violation of the monopolists "rights" is
insane and an indication of a slave mentality (or, following Rousseau, that
the others are _"simple"_). Of course, if the would-be monopolist has the
necessary **force** to withstand the other travellers then his property then
the matter is closed -- might makes right. But to worship rights, even when
they obviously result in despotism, is definitely a case of _"spooks in the
head"_ and "man is created for the Sabbath" not "the Sabbath is created for
man."

## 4.3 How does private property effect individualism?

Private property is usually associated by "anarcho"-capitalism with
individualism. Usually private property is seen as the key way of ensuring
individualism and individual freedom (and that private property is the
expression of individualism). Therefore it is useful to indicate how private
property can have a serious impact on individualism.

Usually right-libertarians contrast the joys of "individualism" with the evils
of "collectivism" in which the individual is sub-merged into the group or
collective and is made to work for the benefit of the group (see any Ayn Rand
book or essay on the evils of collectivism).

But what is ironic is that right-libertarian ideology creates a view of
industry which would (perhaps) shame even the most die-hard fan of Stalin.
What do we mean? Simply that right-libertarians stress the abilities of the
people at the top of the company, the owner, the entrepreneur, and tend to
ignore the very real subordination of those lower down the hierarchy (see,
again, any Ayn Rand book on the worship of business leaders). In the Austrian
school of economics, for example, the entrepreneur is considered the driving
force of the market process and tend to abstract away from the organisations
they govern. This approach is usually followed by right-libertarians. Often
you get the impression that the accomplishments of a firm are the personal
triumphs of the capitalists, as though their subordinates are merely tools not
unlike the machines on which they labour.

We should not, of course, interpret this to mean that right-libertarians
believe that entrepreneurs run their companies single-handedly (although you
do get that impression sometimes!). But these abstractions help hide the fact
that the economy is overwhelmingly interdependent and organised hierarchically
within industry. Even in their primary role as organisers, entrepreneurs
depend on the group. A company president can only issue general guidelines to
his managers, who must inevitably organise and direct much of their
departments on their own. The larger a company gets, the less personal and
direct control an entrepreneur has over it. They must delegate out an
increasing share of authority and responsibility, and is more dependent than
ever on others to help him run things, investigate conditions, inform policy,
and make recommendations. Moreover, the authority structures are from the
"top-down" -- indeed the firm is essentially a command economy, with all
members part of a collective working on a common plan to achieve a common goal
(i.e. it is essentially collectivist in nature -- which means it is not too
unsurprising that Lenin argued that state socialism could be considered as one
big firm or office and why the system he built on that model was so horrific).

So the firm (the key component of the capitalist economy) is marked by a
distinct **lack** of individualism, a lack usually ignored by right
libertarians (or, at best, considered as "unavoidable"). As these firms are
hierarchical structures and workers are paid to obey, it does make **some**
sense -- in a capitalist environment -- to assume that the entrepreneur is the
main actor, but as an individualistic model of activity it fails totally.
Perhaps it would not be unfair to say that capitalist individualism celebrates
the entrepreneur because this reflects a hierarchical system in which for the
one to flourish, the many must obey? (Also see section
[1.1](append131.html#secf11)).

Capitalist individualism does not recognise the power structures that exist
within capitalism and how they affect individuals. In Brian Morris' words,
what they fail _"to recognise is that most productive relations under
capitalism allow little scope for creativity and self-expression on the part
of workers; that such relationships are not equitable; nor are they freely
engaged in for the mutual benefit of both parties, for workers have no control
over the production process or over the product of their labour. Rand [like
other right-libertarians] misleadingly equates trade, artistic production and
wage-slavery. . . [but] wage-slavery . . . is quite different from the trade
principle"_ as it is a form of _"exploitation."_ [**Ecology &amp; Anarchism**,
p. 190]

He further notes that _"[s]o called trade relations involving human labour are
contrary to the egoist values Rand [and other capitalist individualists]
espouses - they involve little in the way of independence, freedom, integrity
or justice."_ [**Ibid.**, p. 191]

Moreover, capitalist individualism actually **supports** authority and
hierarchy. As Joshua Chen and Joel Rogers point out, the _"achievement of
short-run material satisfaction often makes it irrational [from an
individualist perspective] to engage in more radical struggle, since that
struggle is by definition against those institutions which provide one's
current gain."_ In other words, to rise up the company structure, to "better
oneself," (or even get a good reference) you cannot be a pain in the side of
management -- obedient workers do well, rebel workers do not.

Thus the hierarchical structures help develop an "individualistic" perspective
which actually reinforces those authority structures. This, as Cohn and Rogers
notes, means that _"the structure in which [workers] find themselves yields
less than optimal social results from their isolated but economically rational
decisions."_ [quoted by Alfie Kohn, **No Contest**, p. 67, p. 260f]

Steve Biko, a black activist murdered by the South African police in the
1970s, argued that _"the most potent weapon of the oppressor is the mind of
the oppressed."_ And this is something capitalists have long recognised. Their
investment in "Public Relations" and "education" programmes for their
employees shows this clearly, as does the hierarchical nature of the firm. By
having a ladder to climb, the firm rewards obedience and penalises rebellion.
This aims at creating a mind-set which views hierarchy as good and so helps
produce servile people.

This is why anarchists would agree with Alfie Kohn when he argues that _"the
individualist worldview is a profoundly conservative doctrine: it inherently
stifles change."_ [**Ibid.**, p. 67] So, what is the best way for a boss to
maintain his or her power? Create a hierarchical workplace and encourage
capitalist individualism (as capitalist individualism actually works
**against** attempts to increase freedom from hierarchy). Needless to say,
such a technique cannot work forever -- hierarchy also encourages revolt --
but such divide and conquer can be **very** effective.

And as anarchist author Michael Moorcock put it, _"Rugged individualism also
goes hand in hand with a strong faith in paternalism -- albeit a tolerant and
somewhat distant paternalism -- and many otherwise sharp-witted libertarians
seem to see nothing in the morality of a John Wayne Western to conflict with
their views. Heinlein's paternalism is at heart the same as Wayne's. . . To be
an anarchist, surely, is to reject authority but to accept self-discipline and
community responsibility. To be a rugged individualist a la Heinlein and
others is to be forever a child who must obey, charm and cajole to be
tolerated by some benign, omniscient father: Rooster Coburn shuffling his feet
in front of a judge he respects for his office (but not necessarily himself)
in True Grit."_ [**Starship Stormtroopers**]

One last thing, don't be fooled into thinking that individualism or concern
about individuality -- not **quite** the same thing -- is restricted to the
right, they are not. For example, the _"individualist theory of society . . .
might be advanced in a capitalist or in an anti-capitalist form . . . the
theory as developed by critics of capitalism such as Hodgskin and the
anarchist Tucker saw ownership of capital by a few as an obstacle to genuine
individualism, and the individualist ideal was realisable only through the
free association of labourers (Hodgskin) or independent proprietorship
(Tucker)."_ [David Miller, **Social Justice**, pp. 290-1]

And the reason why social anarchists oppose capitalism is that it creates a
**false** individualism, an abstract one which crushes the individuality of
the many and justifies (and supports) hierarchical and authoritarian social
relations. In Kropotkin's words, _"what has been called 'individualism' up to
now has been only a foolish egoism which belittles the individual. It did not
led to what it was established as a goal: that is the complete, broad, and
most perfectly attainable development of individuality."_ The new
individualism desired by Kropotkin _"will not consist . . . in the oppression
of one's neighbour . . . [as this] reduced the [individualist] . . .to the
level of an animal in a herd."_ [**Selected Writings**, p, 295, p. 296]

## 4.4 How does private property affect relationships?

Obviously, capitalist private property affects relationships between people by
creating structures of power. Property, as we have argued all through this
FAQ, creates relationships based upon domination -- and this cannot help but
produce servile tendencies within those subject to them (it also produces
rebellious tendencies as well, the actual ratio between the two tendencies
dependent on the individual in question and the community they are in). As
anarchists have long recognised, power corrupts -- both those subjected to it
and those who exercise it.

While few, if any, anarchists would fail to recognise the importance of
possession -- which creates the necessary space all individuals need to be
themselves -- they all agree that private property corrupts this liberatory
aspect of "property" by allowing relationships of domination and oppression to
be built up on top of it. Because of this recognition, all anarchists have
tried to equalise property and turn it back into possession.

Also, capitalist individualism actively builds barriers between people. Under
capitalism, money rules and individuality is expressed via consumption choices
(i.e. money). But money does not encourage an empathy with others. As Frank
Stronach (chair of Magna International, a Canadian auto-parts maker that
shifted its production to Mexico) put it, _"[t]o be in business your first
mandate is to make money, and money has no heart, no soul, conscience,
homeland."_ [cited by Doug Henwood, **Wall Street**, p. 113] And for those who
study economics, it seems that this dehumanising effect also strikes them as
well:

> _"Studying economics also seems to make you a nastier person. Psychological
studies have shown that economics graduate students are more likely to 'free
ride' -- shirk contributions to an experimental 'public goods' account in the
pursuit of higher private returns -- than the general public. Economists also
are less generous that other academics in charitable giving. Undergraduate
economics majors are more likely to defect in the classic prisoner's dilemma
game that are other majors. And on other tests, students grow less honest --
expressing less of a tendency, for example, to return found money -- after
studying economics, but not studying a control subject like astronomy. _

>

> _"This is no surprise, really. Mainstream economics is built entirely on a
notion of self-interested individuals, rational self-maximisers who can order
their wants and spend accordingly. There's little room for sentiment,
uncertainty, selflessness, and social institutions. Whether this is an
accurate picture of the average human is open to question, but there's no
question that capitalism as a system and economics as a discipline both reward
people who conform to the model."_ [Doug Henwood, **Op. Cit.**, p, 143]

Which, of course, highlights the problems within the "trader" model advocated
by Ayn Rand. According to her, the trader is **the** example of moral
behaviour -- you have something I want, I have something you want, we trade
and we both benefit and so our activity is self-interested and no-one
sacrifices themselves for another. While this has **some** intuitive appeal it
fails to note that in the real world it is a pure fantasy. The trader wants to
get the best deal possible for themselves and if the bargaining positions are
unequal then one person will gain at the expense of the other (if the
"commodity" being traded is labour, the seller may not even have the option of
not trading at all). The trader is only involved in economic exchange, and has
no concern for the welfare of the person they are trading with. They are a
bearer of things, **not** an individual with a wide range of interests,
concerns, hopes and dreams. These are irrelevant, unless you can make money
out of them of course! Thus the trader is often a manipulator and outside
novels it most definitely is a case of "buyer beware!"

If the trader model is taken as the basis of interpersonal relationships,
economic gain replaces respect and empathy for others. It replaces human
relationships with relationships based on things -- and such a mentality does
not encompass how interpersonal relationships affect both you and the society
you life in. In the end, it impoverishes society and individuality. Yes, any
relationship must be based upon self-interest (mutual aid is, after all,
something we do because we benefit from it in some way) but the trader model
presents such a **narrow** self-interest that it is useless and actively
impoverishes the very things it should be protecting -- individuality and
interpersonal relationships (see section [I.7.4](secI7.html#seci74) on how
capitalism does not protect individuality).

## 4.5 Does private property co-ordinate without hierarchy?

It is usually to find right-libertarians maintain that private property (i.e.
capitalism) allows economic activity to be co-ordinated by non-hierarchical
means. In other words, they maintain that capitalism is a system of large
scale co-ordination without hierarchy. These claims follow the argument of
noted right-wing, "free market" economist Milton Friedman who contrasts
_"central planning involving the use of coercion - the technique of the army
or the modern totalitarian state"_ with _"voluntary co-operation between
individuals - the technique of the marketplace"_ as two distinct ways of co-
ordinating the economic activity of large groups (_"millions"_) of people.
[**Capitalism and Freedom**, p. 13].

However, this is just playing with words. As they themselves point out the
internal structure of a corporation or capitalist company is **not** a
"market" (i.e. non-hierarchical) structure, it is a "non-market"
(hierarchical) structure of a market participant (see section
[2.2](append132.html#secf22)). However "market participants" are part of the
market. In other words, capitalism is **not** a system of co-ordination
without hierarchy because it does contain hierarchical organisations which
**are an essential part of the system**!

Indeed, the capitalist company **is** a form of central planning and shares
the same "technique" as the army. As the pro-capitalist writer Peter Drucker
noted in his history of General Motors, _"[t]here is a remarkably close
parallel between General Motors' scheme of organisation and those of the two
institutions most renowned for administrative efficiency: that of the Catholic
Church and that of the modern army . . ."_ [quoted by David Enger, **Apostles
of Greed**, p. 66]. And so capitalism is marked by a series of totalitarian
organisations -- and since when was totalitarianism liberty enhancing? Indeed,
many "anarcho"-capitalists actually celebrate the command economy of the
capitalist firm as being more "efficient" than self-managed firms (usually
because democracy stops action with debate). The same argument is applied by
the Fascists to the political sphere. It does not change much -- nor does it
become less fascistic -- when applied to economic structures. To state the
obvious, such glorification of workplace dictatorship seems somewhat at odds
with an ideology calling itself "libertarian" or "anarchist". Is dictatorship
more liberty enhancing to those subject to it than democracy? Anarchists doubt
it (see section [A.2.11](secA2.html#seca211) for details).

In order to claim that capitalism co-ordinates individual activity without
hierarchy right-libertarians have to abstract from individuals and how they
interact **within** companies and concentrate purely on relationships
**between** companies. This is pure sophistry. Like markets, companies require
at least two or more people to work - both are forms of social co-operation.
If co-ordination within companies is hierarchical, then the system they work
within is based upon hierarchy. To claim that capitalism co-ordinates without
hierarchy is simply false - its based on hierarchy and authoritarianism.
Capitalist companies are based upon denying workers self-government (i.e.
freedom) during work hours. The boss tells workers what to do, when to do, how
to do and for how long. This denial of freedom is discussed in greater depth
in sections [B.1](secB1.html) and [B.4](secB4.html).

Because of the relations of power it creates, opposition to capitalist private
property (and so wage labour) and the desire to see it ended is an essential
aspect of anarchist theory. Due to its ideological blind spot with regards to
apparently "voluntary" relations of domination and oppression created by the
force of circumstances (see section [2](append132.html) for details),
"anarcho"-capitalism considers wage labour as a form of freedom and ignore its
fascistic aspects (when not celebrating those aspects). Thus
"anarcho"-capitalism is not anarchist. By concentrating on the moment the
contract is signed, they ignore that freedom is restricted during the contract
itself. While denouncing (correctly) the totalitarianism of the army, they
ignore it in the workplace. But factory fascism is just as freedom destroying
as the army or political fascism.

Due to this basic lack of concern for freedom, "anarcho"-capitalists cannot be
considered as anarchists. Their total lack of concern about factory fascism
(i.e. wage labour) places them totally outside the anarchist tradition. Real
anarchists have always been aware of that private property and wage labour
restriction freedom and desired to create a society in which people would be
able to avoid it. In other words, where **all** relations are non-hierarchical
and truly co-operative.

To conclude, to claim that private property eliminates hierarchy is false. Nor
does capitalism co-ordinate economic activities without hierarchical
structures. For this reason anarchists support co-operative forms of
production rather than capitalistic forms.

[‹ 3 Why do anarcho"-capitalists place little or no value on
"equality"?](/afaq/append133.html "Go to previous page" )
[up](/afaq/append13.html "Go to parent page" ) [5 Will privatising "the
commons" increase liberty? ›](/afaq/append135.html "Go to next page" )

