/* Copyright (C) 2006 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __TIMER_HPP
#define __TIMER_HPP

#include <boost/shared_ptr.hpp>
#include <sys/time.h>

/// Class for measuring time.    
class timer
{
 public:
  /** Constructor starting timer.
      The constructor will call \c reset() to. */
  timer(void) { reset(); }
  /** Restart timer.
      Reset the time elapsed to zero again. */
  void reset(void) {
    gettimeofday( &time, NULL );
  }
  /** Get elapsed time.
      The time elapsed (in seconds) is returned.
      @return Time elapsed since last call of \c timer or \c reset() . */
  double elapsed(void) const;
 protected:
  /// Time of construction of this object.
  struct timeval time;
};

///
typedef boost::shared_ptr< timer > timer_ptr;


#endif
