<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:output method="html" indent="yes" version="4.0" encoding="UTF-8"/>

  <xsl:param name="lfile">dictionary.xml</xsl:param>
  <xsl:param name="lname">en</xsl:param>

  <xsl:template match="/insert|/sqlout">
    <html>
      <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <title>
          <xsl:value-of select="document($lfile)/dictionary/entry[@text='Cookbook']"/>
        </title>
        <meta name="generator" content="AnyMeal"/>
      </head>
      <body bgcolor="white" text="black" link="#0000FF" vlink="#840084" alink="#0000FF">
        <xsl:apply-templates select="recipe"/>
      </body>
    </html>
  </xsl:template>
  
  <xsl:template match="recipe">
    <h1>
      <xsl:value-of select="document($lfile)/dictionary/entry[@text='Cookbook']"/>
      <xsl:text>: </xsl:text>
      <xsl:value-of select="title"/>
    </h1>
    <table align="right" style="text-align: left; width: 300px; background-color: rgb(255, 255, 221);">

      <tr>
        <th colspan="2" style="text-align: center; background-color: #DDDDBB">
          <xsl:value-of select="title"/>
        </th>
      </tr>
      <!-- <tr>
        <td colspan="2" style="text-align: center">
          <img src="..." alt="" width="300" longdesc="..."/>
        </td>
      </tr> -->
      <tr>
        <td>
          <xsl:value-of select="document($lfile)/dictionary/entry[@text='Categories']"/>
          <xsl:text>: </xsl:text>
        </td>
        <td>
          <xsl:for-each select="categories/category">
            <!-- a href? -->
            <xsl:value-of select="."/>
            <xsl:if test="not(position()=last())">, </xsl:if>          
          </xsl:for-each>
        </td>
      </tr>
      <tr>
        <td>
          <xsl:value-of select="document($lfile)/dictionary/entry[@text='Yield']"/>
          <xsl:text>: </xsl:text>
        </td>
        <td>
          <xsl:value-of select="servings/amount"/>
          <xsl:text> </xsl:text>
          <xsl:value-of select="servings/unit"/>
        </td>
      </tr>
    </table>
    <h2>
      <xsl:value-of select="document($lfile)/dictionary/entry[@text='Ingredients']"/>
    </h2>
    <xsl:for-each select="ingredients/section">
      <xsl:variable name="section" select="column[position()=1]"/>
      <xsl:if test="title">
        <h3>
          <xsl:value-of select="title"/>
        </h3>
      </xsl:if>
      <ul>
        <xsl:for-each select="ingredient">
          <li>
            <xsl:if test="amount">
              <xsl:choose>
                <xsl:when test="amount/float">
                  <xsl:value-of select="amount/float"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:choose>
                    <xsl:when test="amount/fraction/nominator >= amount/fraction/denominator">
                      <xsl:value-of select="floor(amount/fraction/nominator div amount/fraction/denominator)"/>
                      <xsl:if test="amount/fraction/nominator mod amount/fraction/denominator > 0">
                        <xsl:text> </xsl:text>
                        <xsl:value-of select="amount/fraction/nominator mod amount/fraction/denominator"/>
                        <xsl:text>/</xsl:text>
                        <xsl:value-of select="amount/fraction/denominator"/>
                      </xsl:if>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="amount/fraction/nominator"/>
                      <xsl:text>/</xsl:text>
                      <xsl:value-of select="amount/fraction/denominator"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:otherwise>
              </xsl:choose>
              <xsl:text> </xsl:text>
            </xsl:if>
            <xsl:if test="unit">
              <xsl:value-of select="unit"/>
              <xsl:text> </xsl:text>
            </xsl:if>
            <xsl:value-of select="name"/>
            <xsl:if test="prep">
              <xsl:text>; </xsl:text>
              <xsl:value-of select="prep"/>
            </xsl:if>
          </li>
        </xsl:for-each>
      </ul>
    </xsl:for-each>
    <h2><xsl:value-of select="document($lfile)/dictionary/entry[@text='Preparation']"/></h2>
    <xsl:for-each select="instructions/section">
      <xsl:if test="title">
        <h3><xsl:value-of select="title"/></h3>
      </xsl:if>
      <xsl:for-each select="par">
        <p>
          <xsl:value-of select="."/>
        </p>
      </xsl:for-each>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>
