/* Copyright (C) 2002, 2003, 2004 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __OBJECT_HPP
#define __OBJECT_HPP

#include <boost/smart_ptr.hpp>
#include <iostream>

class Object;

///
typedef boost::shared_ptr< Object > ObjectPtr;

/** A base class for nearly every class in this project.
    @date Sun Jan 09 2005
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
class Object
{
public:
#ifndef NDEBUG
  /** Standard constructor.
      The allocated object is counted. If the \c PRINTALLOC is
      defined, a comment will be printed out.
      If \c NDEBUG is not defined, the objects identity \c myId
      will be defined.
      @see objectCount
      @see myId */
  Object(void);
  /** Copy constructor.
      The allocated objects are counted. If the macro \c PRINTALLOC is
      defined, a comment will be printed out. */
  Object( const Object &aObject );
  /// Common virtual destructor
  virtual ~Object(void);
#else
  Object(void) {}
  virtual ~Object(void) {};
#endif
#ifndef NDEBUG
protected:
  ///
  int myId;
private:
  ///
  static int objectCount;
  ///
  static int  objectId;
  ///
  static int objectPeak;
#endif
};

#endif
