
//#define LOCAL_DEBUG
#include "debug.h"

#include "acfg.h"

#include "header.h"
#include "config.h"
#include <acbuf.h>

#include <time.h>
#include <iostream>
#include <string.h>

#include <errno.h>
#include <unistd.h>

using namespace MYSTD;

static const char *szHeadNames[] = {
		  "Connection",    	 // 0
		  "Content-Length",  
		  "If-Modified-Since",
    	  "Range",
    	  "If-Range", // 4
    	  "Content-Range",
    	  "Last-Modified",
    	  "Proxy-Connection",
    	  "Transfer-Encoding", // 8
    	  "X-Original-Source",
    	  "Authorization",
    	  "X-42-Unreachable"
};

header::header()
:
	type(INVALID),
	m_nEstimLength(0)
{
	for(UINT i=0; i<HEADPOS_MAX; i++)
		h[i]=NULL;
}

header::header(const header &s)
:type(s.type), frontLine(s.frontLine), m_nEstimLength(s.m_nEstimLength)
{
	for(UINT i=0; i<HEADPOS_MAX; i++)
		h[i] = s.h[i] ? strdup(s.h[i]) : NULL;
}

header& header::operator=(const header& s)
{
	type=s.type;
	frontLine=s.frontLine;
	m_nEstimLength=s.m_nEstimLength;
	for(UINT i=0; i<HEADPOS_MAX; i++)
	{
		if(h[i])
			free(h[i]);
		h[i]=s.h[i] ? strdup(s.h[i]) : NULL;
	}
	return *this;
}

header::~header()
{
	for(UINT i=0; i<HEADPOS_MAX; i++)
	{
		if(h[i])
			free(h[i]);
		h[i]=NULL;
	}
}

void header::clear()
{
	for(UINT i=0; i<HEADPOS_MAX; i++)
		del((eHeadPos) i);
	frontLine.clear();
	type=INVALID;
	m_nEstimLength=0;
}

void header::del(eHeadPos i)
{
	if(h[i])
		free(h[i]);
	h[i]=0;
}

inline int header::Load(const char * const in, UINT maxlen)
{
	if(maxlen<9)
    	return 0;
    
   if(!in)
    	return -1;
   if(!strncmp(in,  "HTTP/1.", 7))
      type=ANSWER;
   else if(!strncmp(in, "GET ", 4))
      type=GET;
   else if (!strncmp(in, "HEAD ", 5))
		type=HEAD;
   else
	   return -1;
   
	const char *posNext=in;

	while (true)
	{

		const char *szBegin=posNext;
		UINT pos=szBegin-in;
		const char *end=(const char*) memchr(szBegin, '\r', maxlen-pos);
		if (!end)
			return 0;
		if (end+1>=in+maxlen)
			return 0; // one newline must fit there, always

		if (szBegin==end)
		{
			if (end[1]=='\n')
			{
				m_nEstimLength=end+2-in;
				return m_nEstimLength; // end detected
			}

			return -1; // looks like crap
		}
		posNext=end+2;

		while (isspace((UINT)*end))	end--;
		end++;
		
		if (frontLine.empty())
		{
			frontLine.assign(in, end-in);
			trimBack(frontLine);
			continue;
		}

		// end is on the last relevant char now
		const char *sep=(const char*) memchr(szBegin, ':', end-szBegin);
		if (!sep)
			return -1;
		
		// use as cut buffer
		string key;
		key.assign(szBegin, sep-szBegin);

		// trimFront would be slower...
		sep++;
		while (sep<end && isspace((UINT)*sep))
			sep++;
		
		for(UINT i=0; i<HEADPOS_MAX; i++)
		{
			const char *szName=szHeadNames[i];
			if (0==strcasecmp(szName, key.c_str()))
			{
				if (h[i])
				{
					free(h[i]);
					h[i]=NULL;
				}
				UINT l=end-sep;
				h[i] = (char *) malloc(l+1);
				if (h[i])
				{
					memcpy(h[i], sep, l);
					h[i][l]='\0';
				}
			}
		}
	}
	return -2;
}

int header::LoadFromBuf(const char * const in, UINT maxlen)
{
	clear();
	int ret=Load(in, maxlen);
	if(ret<0)
		clear();
	return ret;
}

int header::LoadFromFile(const string &sPath)
{
	clear();
	acbuf buf;
	if(!buf.initFromFile(sPath.c_str()))
		return -1;
	return LoadFromBuf(buf.rptr(), buf.size());
}

void header::set(eHeadPos i, const char *val)
{
	if (h[i])
	{
		free(h[i]);
		h[i]=NULL;
	}
	h[i] = strdup(val);
}

void header::set(eHeadPos key, const MYSTD::string &value) {
	string::size_type l=value.size()+1;
	h[key]=(char*) realloc(h[key], l);
	if(h[key])
		memcpy(h[key], value.c_str(), l);
}

void header::set(eHeadPos key, long nValue) 
{	
	char buf[21];
	sprintf(buf, "%ld", nValue);
    set(key, buf);
}

int header::StoreToFile(const string &sPath) 
{
	int nByteCount(0);
	
	int fd=open(sPath.c_str(), O_WRONLY|O_CREAT|O_TRUNC, 00644);
	if(fd<0)
		return -errno;
	
	string hstr=frontLine+"\r\n";
	for (UINT i=0; i<HEADPOS_MAX; i++)
		if (h[i])
		{
			hstr.append(szHeadNames[i]);
			hstr+=": ";
			hstr+=h[i];
			hstr+="\r\n";
		}
	char buf[26];
	struct tm tmp;
	const time_t cur=time(NULL);
	gmtime_r(&cur, &tmp);
	asctime_r(&tmp, buf);
	hstr+="Date: ";
	hstr.append(buf, 24);
	hstr+="\r\n\r\n";
	const char *p=hstr.c_str();
	nByteCount=hstr.length();
	
	for(string::size_type pos=0; pos<(UINT)nByteCount;)
	{
		int ret=write(fd, p+pos, nByteCount-pos);
		if(ret<0)
		{
			if(EAGAIN == errno || EINTR == errno)
				continue;
			if(EINTR == errno)
				continue;
			
			ret=errno;
			close(fd);
			return -ret;
		}
		pos+=ret;
	}
	if(0!=close(fd))
		return -errno;
	
	return nByteCount;
}

MYSTD::string header::GetInfoHeaders()
{
	    char buf[26];
	    struct tm tmp;
	    const time_t cur=time(NULL);
	    gmtime_r(&cur, &tmp);
	    asctime_r(&tmp, buf);
	    string ret="Date: ";
	    ret.append(buf, 24);
	    ret+="\r\nServer: Debian Apt-Cacher NG/"ACVERSION"\r\n";
	    return ret;
}
